@extends('admin-layouts.master')

@section('content')

<div class="container-fluid">
    <h1 class="h3 mb-2 text-gray-800">Update Data Pemeriksaan Pasien</h1>
    <div class="card">
        <div class="card-body">
            <form  action="{{ route('pemeriksaan.update', $pemeriksaan) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('put')
                {{-- <input type="hidden" name="pasien_id" value="{{ $pasien->id }}"> --}}
                <div class="form-group text-center">
                    <label for=""@error('name') class="text-danger" @enderror >Nama Pasien</label>
                    <input type="text" name="name" class="form-control @error('name') form-control is-invalid @enderror"
                    placeholder="" value="{{ $pemeriksaan->pasien->nama_pasien}}" readonly>
                    @error('name')
                        <span  class="text-danger"> {{ $message }} </span>
                    @enderror
                </div>
                <div class="form-row">
                    <div class="col">
                        <div class="form-group">
                            <label for=""@error('tekanan_darah') class="text-danger" @enderror >Tekanan Darah (mmhg)</label>
                            <input type="text" name="tekanan_darah" class="form-control @error('tekanan_darah') form-control is-invalid @enderror"
                            placeholder="" value="{{$pemeriksaan->tekanan_darah ?? old('tekanan_darah') }}">
                            @error('tekanan_darah')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for=""@error('berat_badan') class="text-danger" @enderror >Berat Badan (Kg)</label>
                            <input type="text" name="berat_badan" class="form-control @error('berat_badan') form-control is-invalid @enderror"
                            placeholder="" value="{{$pemeriksaan->berat_badan ?? old('berat_badan') }}">
                            @error('berat_badan')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for=""@error('tinggi_badan') class="text-danger" @enderror >Tinggi Badan (Cm)</label>
                            <input type="text" name="tinggi_badan" class="form-control @error('tinggi_badan') form-control is-invalid @enderror"
                            placeholder="" value="{{$pemeriksaan->tinggi_badan ?? old('tinggi_badan') }}">
                            @error('tinggi_badan')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                </div>
               
                <div class="form-row">
                    <div class="col">
                        <div class="form-group">
                            <label for=""@error('respi') class="text-danger" @enderror >Respi (x/menit)</label>
                            <input type="text" name="respi" class="form-control @error('respi') form-control is-invalid @enderror"
                            placeholder="" value="{{$pemeriksaan->respi ?? old('respi') }}">
                            @error('respi')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for=""@error('suhu') class="text-danger" @enderror >Suhu Tubuh (°C)</label>
                            <input type="text" name="suhu" class="form-control @error('suhu') form-control is-invalid @enderror"
                            placeholder="" value="{{$pemeriksaan->suhu ?? old('suhu') }}">
                            @error('suhu')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for=""@error('nadi') class="text-danger" @enderror >Nadi (x/menit)</label>
                            <input type="text" name="nadi" class="form-control @error('nadi') form-control is-invalid @enderror"
                            placeholder="" value="{{$pemeriksaan->nadi ?? old('nadi') }}">
                            @error('nadi')
                                <span  class="text-danger"> {{ $message }} </span>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="exampleFormControlTextarea1">Keluhan Utama</label>
                    <textarea class="form-control" id="exampleFormControlTextarea1" rows="3" name="keluhan_utama" value="{{ old('keluhan_utama') }}">{{ $pemeriksaan->keluhan_utama }}</textarea>
                  </div>
                <div class="form-group">
                    <a href="javascript:history.back()" class="btn btn-danger mt-3"> Kembali</a>
                    <input type="submit" value="Simpan" class="btn btn-primary mt-3">
                    
                </div>
            </form>
        </div>
    </div>
</div>
@endsection