<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print SKPT - {{ $application->nama_pemohon }}</title>
    <style>
        @page {
            size: A4;
            margin: 0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 10pt;
            line-height: 1.5;
            color: #000;
        }

        .page {
            width: 210mm;
            min-height: 297mm;
            padding: 15mm 20mm;
            margin: 0 auto;
            background: white;
            page-break-after: always;
        }

        .page:last-child {
            page-break-after: auto;
        }

        /* Page 1 - Cover */
        .cover-page {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            /* min-height: 297mm; */
            border: 3px double #000;
            padding: 30mm 20mm;
            position: relative;
        }

        .cover-content {
            text-align: center;
            width: 100%;
        }

        .logo-container {
            margin-bottom: 40px;
        }

        .logo-container img {
            width: 40%;
            /* height: 150px; */
        }

        .cover-data {
            text-align: left;
            margin: 40px auto;
            max-width: 400px;
        }

        .cover-data table {
            width: 100%;
        }

        .cover-data td {
            padding: 5px 0;
            vertical-align: top;
        }

        .cover-data td:first-child {
            width: 140px;
        }

        .cover-data td:nth-child(2) {
            width: 20px;
            text-align: center;
        }

        .cover-title {
            font-size: 20pt;
            font-weight: bold;
            text-align: center;
            margin-top: 60px;
            line-height: 1.8;
        }

        /* Page 2 - Surat Keterangan */
        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .header-logo {
            width: 80px;
            height: 90px;
            margin: 0 auto 10px;
        }

        .header-title {
            font-size: 16pt;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .header-subtitle {
            font-size: 18pt;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .header-address {
            font-size: 10pt;
            margin-bottom: 10px;
        }

        .header-line {
            border-bottom: 3px double #000;
            margin-bottom: 20px;
        }

        .document-title {
            text-align: center;
            font-size: 14pt;
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 5px;
        }

        .document-number {
            text-align: center;
            margin-bottom: 25px;
        }

        .content {
            text-align: justify;
            line-height: 1.6;
        }

        .official-data {
            margin-left: 40px;
            margin-bottom: 20px;
        }

        .official-data table {
            width: 100%;
        }

        .official-data td {
            padding: 2px 0;
        }

        .official-data td:first-child {
            width: 120px;
        }

        .official-data td:nth-child(2) {
            width: 20px;
            text-align: center;
        }

        .basis-list {
            margin-left: 20px;
            margin-bottom: 15px;
        }

        .basis-list ol {
            list-style-type: none;
            padding-left: 0;
        }

        .basis-list li {
            margin-bottom: 5px;
        }

        .person-data {
            margin-left: 40px;
            margin-bottom: 20px;
        }

        .person-data table {
            width: 100%;
        }

        .person-data td {
            padding: 2px 0;
        }

        .person-data td:first-child {
            width: 120px;
        }

        .person-data td:nth-child(2) {
            width: 20px;
            text-align: center;
        }

        .note-section {
            margin-top: 20px;
            font-style: italic;
            text-align: justify;
        }

        .signature-section {
            margin-top: 40px;
            text-align: right;
            float: right;
            width: 250px;
        }

        .signature-date {
            margin-bottom: 5px;
        }

        .signature-title {
            margin-bottom: 60px;
        }

        .signature-name {
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 5px;
        }

        /* Page 3 - Sket Gambar - IMPROVED */
        .sket-header {
            text-align: center;
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 20px;
        }

        .sket-info {
            border: 2px solid #000;
            margin-bottom: 20px;
        }

        .sket-info table {
            width: 100%;
            border-collapse: collapse;
        }

        .sket-info td {
            padding: 5px 10px;
            border-bottom: 1px solid #000;
        }

        .sket-info td:first-child {
            width: 120px;
            font-weight: bold;
        }

        .sket-info td:nth-child(2) {
            width: 20px;
            text-align: center;
        }

        .sket-info tr:last-child td {
            border-bottom: none;
        }

        .map-container {
            border: 2px solid #000;
            height: 400px;
            position: relative;
            margin-bottom: 0; /* CHANGED: Remove margin to connect with boundary info */
        }

        .compass {
            position: absolute;
            top: 20px;
            right: 30px;
            width: 80px;
            height: 80px;
        }

        .compass svg {
            width: 100%;
            height: 100%;
        }

        .map-area {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            /* border: 2px solid #000; */
            width: 60%;
            height: 50%;
            background: #f0f0f0;
        }

        .boundary-info {
            border: 2px solid #000;
            border-top: none; /* CHANGED: Remove top border to connect with map */
            display: flex;
        }

        .boundary-table {
            flex: 1;
            border-right: 2px solid #000;
        }

        .boundary-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .boundary-table td {
            padding: 2px 5px; /* CHANGED: Reduced padding */
            border-bottom: 1px solid #000;
            font-size: 8pt; /* CHANGED: Smaller font size */
        }

        .boundary-table td:first-child {
            width: 60px; /* CHANGED: Reduced from 80px to 60px */
            font-weight: bold;
            font-size: 8pt; /* CHANGED: Smaller font size */
        }

        .boundary-table td:nth-child(2) {
            width: 15px; /* CHANGED: Reduced from 20px to 15px */
            text-align: center;
            font-size: 8pt; /* CHANGED: Smaller font size */
        }

        .boundary-signature {
            flex: 1;
            padding: 20px;
            text-align: center;
        }

        .coordinate-section {
            margin-top: 10px;
            border-top: 2px solid #000;
            padding-top: 10px;
        }

        .coordinate-section h4 {
            font-weight: bold;
            margin-bottom: 10px;
        }

        .coordinate-table td {
            padding: 2px 5px;
            font-size: 8pt; /* CHANGED: Smaller font size */
        }

        .coordinate-table td:first-child {
            width: 50px; /* CHANGED: Reduced from 80px to 50px */
            font-size: 8pt; /* CHANGED: Smaller font size */
        }

        .coordinate-table td:nth-child(2) {
            width: 12px; /* CHANGED: Reduced from 15px to 12px */
            text-align: center;
        }

        @media print {
            body {
                margin: 0;
            }
            .page {
                margin: 0;
                border: initial;
                page-break-after: always;
            }
        }
    </style>
</head>
<body>
    <!-- Page 1: Cover -->
    <div class="page">
        <div class="cover-page">
            <div class="cover-content">
                <div class="logo-container">
                    <!-- Logo Kabupaten Berau -->
                    <img src="{{asset('images/logo-berau.png')}}" alt="" width="100%">
                </div>

                <div class="cover-data">
                    <table>
                        <tr>
                            <td>Nama</td>
                            <td>:</td>
                            <td>{{ $application->nama_pemohon }}</td>
                        </tr>
                        <tr>
                            <td>NIK</td>
                            <td>:</td>
                            <td>{{ $application->nik }}</td>
                        </tr>
                        <tr>
                            <td>Tempat/Tgl Lahir</td>
                            <td>:</td>
                            <td>{{ $application->tempat_lahir }}, {{ $application->tanggal_lahir ?  \Carbon\Carbon::parse($application->tanggal_lahir)->format('d/m/Y') : '-'}}</td>
                        </tr>
                        <tr>
                            <td>Pekerjaan</td>
                            <td>:</td>
                            <td>{{ $application->pekerjaan }}</td>
                        </tr>
                        <tr>
                            <td>Alamat</td>
                            <td>:</td>
                            <td>RT {{ $application->alamat_rt }} RW {{ $application->alamat_rw }} Kode Pos {{ $application->alamat_kode_pos }}</td>
                        </tr>
                        <tr>
                            <td>Lokasi SP-PAT</td>
                            <td>:</td>
                            <td>{{ $application->letak_tanah }}</td>
                        </tr>
                    </table>
                </div>

                <div class="cover-title">
                    SURAT KETERANGAN PENGUASAAN TANAH<br>
                    ( SKPT )
                </div>
            </div>
        </div>
    </div>

    <!-- Page 2: Surat Keterangan -->
    <div class="page">
        <div class="header">
            <img src="{{asset('images/logo-berau.png')}}" alt="" width="10%">
            <div class="header-title">PEMERINTAH KABUPATEN BERAU</div>
            <div class="header-subtitle">KECAMATAN BIDUK-BIDUK</div>
            <div class="header-address">Alamat : Jl. Belimbing No.01 RT.02 Biduk-Biduk, Kec Biduk-Biduk, Kab. Berau Kodepos 77373</div>
            <div class="header-line"></div>
        </div>

        <div class="document-title">SURAT KETERANGAN PENGUASAAN TANAH (SKPT)</div>
        <div class="document-number">Nomor : {{ $application->no_registrasi ?? '................................' }}</div>

        <div class="content">
            <p>Yang bertanda tangan dibawah ini, Camat Biduk-Biduk, Kabupaten Berau :</p>

            <div class="official-data">
                <table>
                    <tr>
                        <td>Nama</td>
                        <td>:</td>
                        <td>{{ $application->dataPeninjauan->dataKecamatan->nama_camat ?? '................................' }}</td>
                    </tr>
                    <tr>
                        <td>NIP</td>
                        <td>:</td>
                        <td>{{ $application->dataPeninjauan->dataKecamatan->nip ?? '................................' }}</td>
                    </tr>
                    <tr>
                        <td>Gol / Pangkat</td>
                        <td>:</td>
                        <td>{{ $application->dataPeninjauan->dataKecamatan->golongan ?? '................................' }} / {{ $application->dataPeninjauan->dataKecamatan->pangkat ?? '................................' }}</td>
                    </tr>
                    <tr>
                        <td>Alamat</td>
                        <td>:</td>
                        <td>{{ $application->dataPeninjauan->dataKecamatan->alamat_kantor_kecamatan ?? '................................' }}</td>
                    </tr>
                </table>
            </div>

            <p style="margin-top:-20px;"><strong>1. Berdasarkan :</strong></p>
            <div class="basis-list">
                <ol type="a">
                    <li>a. Pengantar Kepala Kampung/Lurah Nomor : {{ $application->dataPeninjauan->nomor_ba_kesaksian ?? '............' }}, Tanggal : {{ $application->dataPeninjauan->ba_tanggal ? \Carbon\Carbon::parse($application->dataPeninjauan->ba_tanggal)->format('d/m/Y') : '.....' }}</li>
                    <li>b. Berita Acara Penelitian Penguasaan atas Tanah Nomor : {{ $application->dataPeninjauan->beritaAcara->where('type', 'penelitian')->first()->nomor_berita_acara ?? '................' }}, Tanggal : {{ $application->dataPeninjauan->bulan_tahun_penelitian ? \Carbon\Carbon::parse($application->dataPeninjauan->bulan_tahun_penelitian)->format('d/m/Y') : '......' }}</li>
                    <li>c. Berita Acara Pengukuran Bidang Tanah Nomor : {{ $application->dataPeninjauan->beritaAcara->where('type', 'pengukuran')->first()->nomor_berita_acara ?? '.....' }} Tanggal {{ $application->dataPeninjauan->tanggal_pengukuran ? \Carbon\Carbon::parse($application->dataPeninjauan->tanggal_pengukuran)->format('d/m/Y') : '........' }}</li>
                    <li>d. Berita Acara Kesepakatan Batas dan Pernyataan tidak Sengketa Nomor : {{ $application->dataPeninjauan->beritaAcara->where('type', 'kesepakatan')->first()->nomor_berita_acara ?? '.........' }}, Tanggal : {{ $application->dataPeninjauan->ba_tanggal ? \Carbon\Carbon::parse($application->dataPeninjauan->ba_tanggal)->format('d/m/Y') : '.......' }}</li>
                    <li>e. Berita Acara Persetujuan pengukuran Tanah Nomor : {{ $application->dataPeninjauan->beritaAcara->where('type', 'persetujuan')->first()->nomor_berita_acara ?? '...............' }}, Tanggal : {{ $application->dataPeninjauan->tanggal_permohonan_pengukuran ? \Carbon\Carbon::parse($application->dataPeninjauan->tanggal_permohonan_pengukuran)->format('d/m/Y') : '.............' }}</li>
                </ol>
            </div>

            <p style="margin-top:-20px;"><strong>2. Menerangkan dengan sebenarnya, bahwa :</strong></p>

            <div class="person-data">
                <table>
                    <tr>
                        <td>Nama</td>
                        <td>:</td>
                        <td>{{ $application->nama_pemohon }}</td>
                    </tr>
                    <tr>
                        <td>NIK</td>
                        <td>:</td>
                        <td>{{ $application->nik }}</td>
                    </tr>
                    <tr>
                        <td>Tempat/Tgl. Lahir</td>
                        <td>:</td>
                        <td>{{ $application->tempat_lahir }}, {{ \Carbon\Carbon::parse($application->tanggal_lahir)->format('d/m/Y') }}</td>
                    </tr>
                    <tr>
                        <td>Pekerjaan</td>
                        <td>:</td>
                        <td>{{ $application->pekerjaan }}</td>
                    </tr>
                    <tr>
                        <td>Alamat</td>
                        <td>:</td>
                        <td>RT {{ $application->alamat_rt }} RW {{ $application->alamat_rw }} Kode Pos {{ $application->alamat_kode_pos }}</td>
                    </tr>
                </table>
            </div>

            <p style="margin-top:-20px;">Adalah orang/pihak yang menguasai/menggunakan sebidang tanah seluas <strong>± {{ number_format($application->dataPeninjauan->luas_terukur_otomatis ?? $application->luas, 0, ',', '.') }} M²</strong> yang terletak di Jalan/Gang/Blok {{ $application->dataPeninjauan->jalan_gg_blok ?? $application->letak_tanah }}, dan penggunaan tanah saat ini {{ strtolower($application->peruntukan) }}.</p>

            <div class="note-section" style="margin-top:-5px;font-size:11px;">
                <p><strong>Catatan :</strong><br>
                SKPT ini tidak Berlaku Jika Pemilik Tanah Tidak Menggunakan dan Menelantarkan Tanahnya dan SKPT ini berlaku selama 4 Tahun sejak tanggal ditetapkan ( Sampai Tahun {{ date('Y') + 4 }} ) dan di perpanjang 1 kali dengan jangka waktu 2 Tahun.</p>
            </div>

            <p style="">Demikian Surat Keterangan Penguasaan Tanah ini dibuat dengan sebenarnya.</p>

            <div class="signature-section">
                <div class="signature-date">Biduk-Biduk, {{ \Carbon\Carbon::now()->format('d F Y') }}</div>
                <div class="signature-title">Camat,</div>
                <div class="signature-name">{{ $application->dataPeninjauan->dataKecamatan->nama_camat ?? '.........................................' }}</div>
                <div>NIP. {{ $application->dataPeninjauan->dataKecamatan->nip ?? '................................................' }}</div>
            </div>
            {{-- <div style="clear: both;"></div> --}}
        </div>
    </div>

    <!-- Page 3: Sket Gambar -->
    <div class="page">
        <div class="sket-header">SKET GAMBAR SITUASI</div>

        <div class="sket-info">
            <table>
                <tr>
                    <td>JALAN</td>
                    <td>:</td>
                    <td>{{ $application->dataPeninjauan->jalan_gg_blok ?? $application->letak_tanah }}</td>
                </tr>
                <tr>
                    <td>KAMPUNG</td>
                    <td>:</td>
                    <td>{{ $application->dataPeninjauan->kampung_kelurahan ?? $application->kelurahan_kampung }}</td>
                </tr>
                <tr>
                    <td>KECAMATAN</td>
                    <td>:</td>
                    <td>{{ $application->dataPeninjauan->dataKecamatan->nama_kecamatan ?? 'BIDUK-BIDUK' }}</td>
                </tr>
                <tr>
                    <td>KABUPATEN</td>
                    <td>:</td>
                    <td>BERAU</td>
                </tr>
                <tr>
                    <td>PROVINSI</td>
                    <td>:</td>
                    <td>KALIMANTAN TIMUR</td>
                </tr>
                <tr>
                    <td>PEMILIK</td>
                    <td>:</td>
                    <td>{{ $application->nama_pemohon }}</td>
                </tr>
                <tr>
                    <td>LUAS</td>
                    <td>:</td>
                    <td>± {{ number_format($application->dataPeninjauan->luas_terukur_otomatis ??$application->luas, 0, ',', '.') }} m²</td>
                </tr>
            </table>
        </div>

        <div class="map-container">
            <div class="compass">
                {{-- <svg viewBox="0 0 100 100">
                    <circle cx="50" cy="50" r="45" fill="white" stroke="black" stroke-width="2"/>
                    <path d="M50 10 L40 30 L50 25 L60 30 Z" fill="black"/>
                    <path d="M50 90 L40 70 L50 75 L60 70 Z" fill="white" stroke="black" stroke-width="1"/>
                    <path d="M10 50 L30 40 L25 50 L30 60 Z" fill="white" stroke="black" stroke-width="1"/>
                    <path d="M90 50 L70 40 L75 50 L70 60 Z" fill="white" stroke="black" stroke-width="1"/>
                    <text x="50" y="8" text-anchor="middle" font-size="14" font-weight="bold">U</text>
                    <text x="50" y="98" text-anchor="middle" font-size="14" font-weight="bold">S</text>
                    <text x="5" y="54" text-anchor="middle" font-size="14" font-weight="bold">B</text>
                    <text x="95" y="54" text-anchor="middle" font-size="14" font-weight="bold">T</text>
                </svg> --}}
                <img src="{{asset('images/mata angin.png')}}" alt="" style="width:90%;">
            </div>

            <div class="map-area">
                <!-- Area peta akan ditampilkan di sini -->
                {{-- @if($application->dataPeninjauan && $application->dataPeninjauan->coordinates->count() > 0)
                <svg viewBox="0 0 400 300" style="width: 100%; height: 100%;">
                    <polygon points="
                        @foreach($application->dataPeninjauan->coordinates as $coord)
                            {{ ($coord->longitude - $application->dataPeninjauan->coordinates->min('longitude')) * 1000 }},{{ ($coord->latitude - $application->dataPeninjauan->coordinates->min('latitude')) * -1000 + 250 }}
                        @endforeach
                    " fill="#e0e0e0" stroke="black" stroke-width="2"/>
                </svg>
                @endif --}}
                {{-- @dd($application->dataPeninjauan->lastMapImage->file_path); --}}
                <img src="{{ Storage::url($application->dataPeninjauan->lastMapImage->file_path ?? '') }}" alt="" width="100%">
            </div>
        </div>

        <div class="boundary-info">
            <div class="boundary-table">
                <table>
                    <tr>
                        <td>UTARA</td>
                        <td>:</td>
                        <td>{{ $application->dataPeninjauan->batas_utara ?? '..............................' }}</td>
                    </tr>
                    <tr>
                        <td>TIMUR</td>
                        <td>:</td>
                        <td>{{ $application->dataPeninjauan->batas_timur ?? '..............................' }}</td>
                    </tr>
                    <tr>
                        <td>SELATAN</td>
                        <td>:</td>
                        <td>{{ $application->dataPeninjauan->batas_selatan ?? '..............................' }}</td>
                    </tr>
                    <tr>
                        <td>BARAT</td>
                        <td>:</td>
                        <td>{{ $application->dataPeninjauan->batas_barat ?? '..............................' }}</td>
                    </tr>
                </table>

                <div class="coordinate-section">
                    @if($application->dataPeninjauan && $application->dataPeninjauan->coordinatesUtm->count() > 0)
                        {{-- Data UTM tersedia --}}
                        <h4 style="margin-left:10px;">Titik Koordinat UTM (Zone 50N):</h4>
                        <table class="coordinate-table">
                            @foreach($application->dataPeninjauan->coordinatesUtm as $index => $coord)
                            <tr>
                                <td>Titik - {{ $index + 1 }}</td>
                                <td>:</td>
                                <td>Easting = {{ number_format($coord->easting, 2, ',', '.') }} m - Northing = {{ number_format($coord->northing, 2, ',', '.') }} m</td>
                            </tr>
                            @endforeach
                        </table>
                    @elseif($application->dataPeninjauan && $application->dataPeninjauan->coordinates->count() > 0)
                        {{-- Convert Lat/Long ke UTM via JavaScript --}}
                        <h4 style="margin-left:10px;">Titik Koordinat (Loading...):</h4>
                        <table class="coordinate-table">
                            @foreach($application->dataPeninjauan->coordinates as $index => $coord)
                            <tr>
                                <td>Titik - {{ $index + 1 }}</td>
                                <td>:</td>
                                <td data-lat="{{ $coord->latitude }}" data-lng="{{ $coord->longitude }}">Converting...</td>
                            </tr>
                            @endforeach
                        </table>
                    @else
                        <h4 style="margin-left:10px;">Titik Koordinat:</h4>
                        <table class="coordinate-table">
                            <tr>
                                <td colspan="3" style="text-align: center;">Tidak ada data koordinat</td>
                            </tr>
                        </table>
                    @endif
                </div>
            </div>

            <div class="boundary-signature">
                <p>Yang membuat Sket/Gambar Tanah</p>
                <br><br><br><br>
                <p style="font-weight: bold; text-decoration: underline;">
                    {{ $application->dataPeninjauan->juru_ukur_nama ?? '............................................' }}
                </p>
                <p>NIP. {{ $application->dataPeninjauan->petugas1_nip ?? '...........................................................' }}</p>
            </div>
        </div>
    </div>

    <!-- Proj4js for UTM conversion -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/proj4js/2.7.4/proj4.js"></script>

    <script>
        // UTM Conversion Setup
        proj4.defs("EPSG:32750", "+proj=utm +zone=50 +south +datum=WGS84 +units=m +no_defs");
        const wgs84 = "EPSG:4326";
        const utm50s = "EPSG:32750";

        // Convert Lat/Lng to UTM
        function latLngToUTM(lat, lng) {
            try {
                const [easting, northing] = proj4(wgs84, utm50s, [parseFloat(lng), parseFloat(lat)]);
                return { easting, northing };
            } catch (error) {
                console.error('Error converting Lat/Lng to UTM:', error);
                return null;
            }
        }

        // Format number with Indonesian locale
        function formatNumber(num) {
            return num.toFixed(2).replace('.', ',').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
        }

        // Convert coordinates on page load if needed
        window.addEventListener('DOMContentLoaded', function() {
            @if($application->dataPeninjauan && $application->dataPeninjauan->coordinatesUtm->count() === 0 && $application->dataPeninjauan->coordinates->count() > 0)
                // Get coordinate cells with lat/lng data
                const coordCells = document.querySelectorAll('.coordinate-table td[data-lat]');

                // Convert and update each cell
                coordCells.forEach((cell) => {
                    const lat = parseFloat(cell.getAttribute('data-lat'));
                    const lng = parseFloat(cell.getAttribute('data-lng'));

                    const utm = latLngToUTM(lat, lng);
                    if (utm) {
                        cell.textContent = `Easting = ${formatNumber(utm.easting)} m - Northing = ${formatNumber(utm.northing)} m`;
                    } else {
                        cell.textContent = `Lat: ${lat.toFixed(6)}, Long: ${lng.toFixed(6)}`;
                    }
                });

                // Update header to show UTM
                const header = document.querySelector('.coordinate-section h4');
                if (header && coordCells.length > 0) {
                    header.textContent = 'Titik Koordinat UTM (Zone 50S - Converted):';
                }
            @endif

            // Auto print after conversion
            setTimeout(function() {
                window.print();
            }, 500);
        });
    </script>
</body>
</html>
