<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Pengeluaran - {{ date('d/m/Y H:i:s') }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Times New Roman', serif;
            font-size: 12px;
            line-height: 1.4;
            color: #000;
            margin: 20px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #000;
            padding-bottom: 15px;
        }
        
        .header h1 {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 5px;
            text-transform: uppercase;
        }
        
        .header p {
            font-size: 12px;
            margin-bottom: 3px;
        }
        
        .info-section {
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
        }
        
        .info-left, .info-right {
            width: 48%;
        }
        
        .info-item {
            margin-bottom: 5px;
        }
        
        .info-label {
            font-weight: bold;
            display: inline-block;
            width: 120px;
        }
        
        .filter-info {
            background-color: #f8f9fa;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
        }
        
        .filter-info h3 {
            font-size: 14px;
            margin-bottom: 8px;
        }
        
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        .table th,
        .table td {
            border: 1px solid #000;
            padding: 6px 8px;
            text-align: left;
        }
        
        .table th {
            background-color: #e9ecef;
            font-weight: bold;
            text-align: center;
            font-size: 11px;
            text-transform: uppercase;
        }
        
        .table td {
            font-size: 11px;
        }
        
        .table .text-center {
            text-align: center;
        }
        
        .table .text-right {
            text-align: right;
        }
        
        .table .currency {
            font-weight: bold;
            color: #d63384;
        }
        
        .summary {
            margin-top: 20px;
            border-top: 2px solid #000;
            padding-top: 15px;
        }
        
        .summary-table {
            width: 50%;
            margin-left: auto;
        }
        
        .summary-table td {
            border: none;
            padding: 5px 10px;
        }
        
        .summary-table .label {
            font-weight: bold;
            text-align: right;
        }
        
        .summary-table .value {
            text-align: right;
            font-weight: bold;
        }
        
        .total-row {
            border-top: 1px solid #000;
            font-size: 14px;
        }
        
        .footer {
            margin-top: 40px;
            text-align: right;
        }
        
        .signature {
            margin-top: 60px;
            text-align: center;
        }
        
        .signature-box {
            display: inline-block;
            text-align: center;
            margin: 0 50px;
        }
        
        .signature-line {
            border-top: 1px solid #000;
            width: 200px;
            margin: 50px auto 5px;
        }
        
        .badge {
            background-color: #007bff;
            color: white;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: bold;
        }
        
        @media print {
            body {
                margin: 0;
                font-size: 11px;
            }
            
            .no-print {
                display: none !important;
            }
            
            .page-break {
                page-break-before: always;
            }
        }
        
        @page {
            margin: 2cm;
        }
    </style>
</head>
<body>
    <!-- Print Button -->
    <div class="no-print" style="text-align: center; margin-bottom: 20px;">
        <button onclick="window.print()" style="background: #007bff; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; font-size: 14px;">
            <i class="fas fa-print"></i> Cetak Laporan
        </button>
        <button onclick="window.close()" style="background: #6c757d; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; font-size: 14px; margin-left: 10px;">
            <i class="fas fa-times"></i> Tutup
        </button>
    </div>

    <!-- Header -->
    <div class="header">
        <h1>Laporan Data Pengeluaran</h1>
        <p>Sistem Pencatatan Pengeluaran</p>
        <p>Periode: {{ date('d F Y') }}</p>
    </div>

    <!-- Info Section -->
    <div class="info-section">
        <div class="info-left">
            <div class="info-item">
                <span class="info-label">Tanggal Cetak:</span>
                {{ date('d F Y H:i:s') }}
            </div>
            <div class="info-item">
                <span class="info-label">Total Data:</span>
                {{ number_format($pengeluarans->count()) }} item
            </div>
            @if(!empty($filterInfo))
            <div class="info-item">
                <span class="info-label">Filter:</span>
                {{ implode(', ', $filterInfo) }}
            </div>
            @endif
        </div>
        <div class="info-right">
            <div class="info-item">
                <span class="info-label">Total Pengeluaran:</span>
                <strong>Rp {{ number_format($totalPengeluaran, 0, ',', '.') }}</strong>
            </div>
        </div>
    </div>

    <!-- Data Table -->
    <table class="table">
        <thead>
            <tr>
                <th width="5%">No</th>
                <th width="15%">Tanggal</th>
                <th width="50%">Deskripsi</th>
                <th width="30%">Jumlah Pengeluaran</th>
            </tr>
        </thead>
        <tbody>
            @forelse($pengeluarans as $index => $pengeluaran)
            <tr>
                <td class="text-center">{{ $index + 1 }}</td>
                <td class="text-center">
                    <span class="badge">{{ $pengeluaran->tanggal->format('d/m/Y') }}</span>
                </td>
                <td>{{ $pengeluaran->deskripsi }}</td>
                <td class="text-right currency">
                    Rp {{ number_format($pengeluaran->jumlah_pengeluaran, 0, ',', '.') }}
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="4" class="text-center" style="padding: 20px;">
                    <em>Tidak ada data pengeluaran untuk ditampilkan</em>
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>

    <!-- Summary -->
    <div class="summary">
        <table class="summary-table">
            <tr>
                <td class="label">Total Data:</td>
                <td class="value">{{ number_format($pengeluarans->count()) }} item</td>
            </tr>
            <tr class="total-row">
                <td class="label">Total Pengeluaran:</td>
                <td class="value currency">Rp {{ number_format($totalPengeluaran, 0, ',', '.') }}</td>
            </tr>
        </table>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p><em>Laporan ini digenerate secara otomatis oleh sistem pada {{ date('d F Y \p\u\k\u\l H:i:s') }}</em></p>
    </div>

    <!-- Signature -->
    {{-- <div class="signature">
        <div style="display: flex; justify-content: space-between; margin-top: 50px;">
            <div class="signature-box">
                <p>Dibuat Oleh,</p>
                <div class="signature-line"></div>
                <p>Admin</p>
            </div>
            <div class="signature-box">
                <p>Diketahui Oleh,</p>
                <div class="signature-line"></div>
                <p>Manager</p>
            </div>
        </div>
    </div> --}}

    <script>
        // Auto print when page loads (optional)
        // window.onload = function() {
        //     window.print();
        // }
    </script>
</body>
</html>