<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Berita Acara Pengukuran Bidang Tanah</title>
    <style>
        body { font-family: 'Times New Roman', Times, serif; font-size: 11pt; line-height: 1.2; margin: 1.2cm; }
        .center { text-align: center; }
        .right { text-align: right; }
        .table { width: 100%; border-collapse: collapse; }
        .table td, .table th { padding: 2px 3px; vertical-align: top; }
        .bordered { border: 1px solid #000; }
        .bordered td, .bordered th { border: 1px solid #000; padding: 4px; }
        .signature { height: 60px; }
        .mt-2 { margin-top: 0.5em; }
        .mt-4 { margin-top: 1em; }
        .judul { font-size: 14pt; font-weight: bold; }
        .nomor { font-size: 11pt; }
        .indent { text-indent: 1.2em; }
        .bold { font-weight: bold; }
    </style>
</head>
<body>
    <div class="center">
        <span class="judul">BERITA ACARA PENGUKURAN BIDANG TANAH</span><br>
        <span class="nomor">Nomor: {{ isset($peninjauan->nomor_ba_kesaksian) ? str_replace('BA-', 'BA-PBT-', $peninjauan->nomor_ba_kesaksian) : '_________' }}</span>
    </div>
    <br>

    <p class="indent">Pada hari ini {{ \Carbon\Carbon::parse($peninjauan->tanggal_pengukuran ?? now())->translatedFormat('l') }}, tanggal {{ \Carbon\Carbon::parse($peninjauan->tanggal_pengukuran ?? now())->translatedFormat('d F Y') }} telah dilaksanakan Pengukuran sebidang tanah yang dikuasai/digunakan oleh Saudara {{ $peninjauan->nama_pemilik ?? '.................'  }} dengan lokasi:</p>

    <table style="width:100%; font-size:11pt; margin-bottom:0.5em;">
        <tr>
            <td valign="top" width="5%">1.</td>
            <td valign="top" width="30%">Letak tanah</td>
            <td valign="top" width="65%"></td>
        </tr>
        <tr>
            <td></td>
            <td>Jalan/Gang/Blok</td>
            <td>: {{ $peninjauan->jalan_gg_blok ?? '....................................................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>RT/RW</td>
            <td>: {{ $peninjauan->rt ?? '...........' }}/{{ $peninjauan->rw ?? '...........' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>Kampung/Kelurahan</td>
            <td>: {{ $peninjauan->kampung_kelurahan ?? '....................................................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>Kecamatan</td>
            <td>: {{ $peninjauan->dataKecamatan->nama_kecamatan ?? '....................................................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>Kabupaten</td>
            <td>: {{ $peninjauan->kabupaten ?? 'Berau' }}</td>
        </tr>
        <tr><td colspan="3" style="height:10px;"></td></tr>
        <tr>
            <td valign="top">2.</td>
            <td valign="top">Keterangan Pengukuran</td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td>- Surat tugas</td>
            <td>Nomor : {{ $peninjauan->surat_tugas_nomor ?? '....................' }} tanggal : {{ $peninjauan->surat_tugas_tanggal ? \Carbon\Carbon::parse($peninjauan->surat_tugas_tanggal)->format('d/m/Y') : '....................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>- Petugas ukur</td>
            <td>1. {{ $peninjauan->nama_petugas_ukur_1 ?? '....................' }} 2. {{ $peninjauan->nama_petugas_ukur_2 ?? '....................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>- Tanggal pengukuran</td>
            <td>{{ $peninjauan->tanggal_pengukuran ? \Carbon\Carbon::parse($peninjauan->tanggal_pengukuran)->format('d/m/Y') : '....................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>- Tanda tangan</td>
            <td>1. .................... 2. ....................</td>
        </tr>
        <tr><td colspan="3" style="height:10px;"></td></tr>
        <tr>
            <td valign="top">3.</td>
            <td valign="top">Keterangan</td>
            <td></td>
        </tr>
        <tr>
            <td></td>
            <td>- Tanda batas</td>
            <td>: {{ $peninjauan->tanda_batas ?? '....................................................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>- Penggunaan tanah</td>
            <td>: {{ $peninjauan->penggunaan_tanah ?? '....................................................' }}</td>
        </tr>
        <tr>
            <td></td>
            <td>- Status</td>
            <td>: {{ $peninjauan->status_tanah ?? '....................................................' }}</td>
        </tr>
    </table>
    <br>

    <table style="width:100%; border:1px solid #000; margin-bottom:0.3em; font-size:11pt;">
        <tr>
            <td style="padding:3px; font-weight:bold; text-align:center; border-bottom:1px solid #000;" colspan="2">Sket Lokasi</td>
        </tr>
        <tr>
            <td style="width:50%; vertical-align:top; padding:4px; border-right:1px solid #000;">
                @if(!empty($mapImg))
                    <img src="{{ $mapImg }}" alt="Sket Lokasi" style="width:100%;">
                @else
                    <img src="{{ public_path('images/no-image.png') }}" alt="Sket Lokasi" style="width:100%;">
                    {{-- atau tampilkan <p>Tidak ada gambar</p> --}}
                @endif
            </td>
            <td style="width:50%; vertical-align:top; padding:4px;">
                 <ul style="margin:0; padding-left:14px;">
                    <li style="margin-bottom:2px;">Bahwa saya menjamin batas batas bidang tanah maupun letak posisi di lapangan adalah benar saya tunjukkan kepada petugas ukur</li>
                    <li style="margin-bottom:2px;">Apabila dikemudian hari terdapat masalah terhadap bidang tanah tersebut maka saya bertanggung jawab secara hukum</li>
                </ul>
                <div style="margin-bottom:10px;">Petunjuk batas,</div>
                <div>1. .................... 2. ....................</div>
            </td>
        </tr>
    </table>

    {{-- <table style="width:100%; border-collapse:collapse; font-size:11pt;">
        <tr>
            <td colspan="3" style="font-weight:bold; text-align:center; border:1px solid #000; padding:6px;">Hasil Pengukuran</td>
        </tr>
        <tr>
            <td style="width:40%; font-weight:bold; border:1px solid #000; padding:6px; text-align:center;">Nama pemilik tanah/saksi batas</td>
            <td style="width:30%; font-weight:bold; border:1px solid #000; padding:6px; text-align:center;">Tanda tangan saksi batas</td>
            <td style="width:30%; font-weight:bold; border:1px solid #000; padding:6px; text-align:center;">Meter/Titik koordinat</td>
        </tr>
        <tr>
            <td style="border:1px solid #000; padding:6px;">Utara&nbsp;&nbsp;1.&nbsp;{{ $peninjauan->saksi_batas_utara ?? '...............' }}</td>
            <td style="border:1px solid #000; padding:6px;">1.&nbsp;............... </td>
            <td style="border:1px solid #000; padding:6px;">{{ $peninjauan->koordinat_utara ?? '...............' }}</td>
        </tr>
        <tr>
            <td style="border:1px solid #000; padding:6px;">Timur&nbsp;&nbsp;2.&nbsp;{{ $peninjauan->saksi_batas_timur ?? '...............' }}</td>
            <td style="border:1px solid #000; padding:6px;">2.&nbsp;............... </td>
            <td style="border:1px solid #000; padding:6px;">{{ $peninjauan->koordinat_timur ?? '...............' }}</td>
        </tr>
        <tr>
            <td style="border:1px solid #000; padding:6px;">Selatan&nbsp;&nbsp;3.&nbsp;{{ $peninjauan->saksi_batas_selatan ?? '...............' }}</td>
            <td style="border:1px solid #000; padding:6px;">3.&nbsp;............... </td>
            <td style="border:1px solid #000; padding:6px;">{{ $peninjauan->koordinat_selatan ?? '...............' }}</td>
        </tr>
        <tr>
            <td style="border:1px solid #000; padding:6px;">Barat&nbsp;&nbsp;4.&nbsp;{{ $peninjauan->saksi_batas_barat ?? '...............' }}</td>
            <td style="border:1px solid #000; padding:6px;">4.&nbsp;............... </td>
            <td style="border:1px solid #000; padding:6px;">{{ $peninjauan->koordinat_barat ?? '...............' }}</td>
        </tr>
    </table> --}}
</body>
</html>
