<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Berita Acara Persetujuan Pengukuran Tanah</title>
    <style>
        body { font-family: 'Times New Roman', Times, serif; font-size: 11pt; line-height: 1.6; margin: 2cm; }
        .center { text-align: center; }
        .right { text-align: right; }
        .underline { border-bottom: 1px solid #000; display: inline-block; width: 200px; }
        .indent { text-indent: 2em; }
        .mt-4 { margin-top: 2em; }
    </style>
</head>
<body>
    <div class="center">
        <span style="font-size: 16pt; font-weight: bold;">BERITA ACARA PERSETUJUAN PENGUKURAN TANAH</span><br>
        <span style="font-size: 13pt;">Nomor: {{ isset($peninjauan->nomor_ba_kesaksian) ? str_replace('BA-', 'BA-PPT-', $peninjauan->nomor_ba_kesaksian) : '_________' }}</span>
    </div>
    <br>

    <p class="indent">Pada hari ini {{ \Carbon\Carbon::parse($peninjauan->tanggal_pengukuran ?? now())->translatedFormat('l') }} Tanggal {{ \Carbon\Carbon::parse($peninjauan->tanggal_pengukuran ?? now())->format('d') }} Bulan {{ \Carbon\Carbon::parse($peninjauan->tanggal_pengukuran ?? now())->translatedFormat('F') }} Tahun {{ \Carbon\Carbon::parse($peninjauan->tanggal_pengukuran ?? now())->format('Y') }} telah melaksanakan Pengukuran sebidang tanah/beberapa bidang tanah *) yang terletak:</p>

    <table style="width:100%; margin-bottom: 0.5em; font-size: 12pt;">
        <tr>
            <td style="width: 35%;">Jalan/Gang/Blok</td>
            <td style="width: 5%;">:</td>
            <td style="width: 60%;">{{ $peninjauan->jalan_gg_blok ?? '.................................................... ' }}</td>
        </tr>
        <tr>
            <td>RT/RW</td>
            <td>:</td>
            <td>{{ $peninjauan->rt ?? '.................................................... ' }} / {{ $peninjauan->rw }}</td>
        </tr>
        <tr>
            <td>Kampung/Kelurahan</td>
            <td>:</td>
            <td>{{ $peninjauan->kampung_kelurahan ?? '.................................................... ' }}</td>
        </tr>
        <tr>
            <td>Kecamatan</td>
            <td>:</td>
            <td>{{ $peninjauan->dataKecamatan->nama_kecamatan ?? '.................................................... ' }}</td>
        </tr>
        <tr>
            <td>Luas</td>
            <td>:</td>
            <td>{{ $peninjauan->luas .' m²' ?? '.................................................... ' }}</td>
        </tr>
    </table>

    <p class="indent">Berdasarkan permohonan dari {{ $peninjauan->skpt->nama_pemohon ?? '_________' }} tanggal {{ $peninjauan->ba_tanggal ? \Carbon\Carbon::parse($peninjauan->ba_tanggal)->format('d/m/Y') : '_________' }} pada saat dilaksanakan pengukuran tanah dibawah ini:</p>

    <ol style="margin-left:2em;">
        <li>Tanah tersebut tidak dalam keadaan sengketa penguasaan/penggunaan dengan pihak manapun;</li>
        <li>Batas-batas tanah telah terpasang berupa {{ $peninjauan->tanda_batas ? str_repeat('.', 10) : '...........' }} </li>
        <li>Para pemilik tanah tetangga yang berbatasan <b>TIDAK DAPAT HADIR</b> sehingga <b>TIDAK DAPAT MENANDATANGANI</b> "Berita Acara Pemeriksaan Lokasi dan Pengukuran Tanah" ini sebagai tanda persetujuan pengukuran batas tanah.</li>
    </ol>

    <p class="indent">Pengukuran batas tanah dan letak tanah ini ditunjukkan oleh {{ $peninjauan->skpt->nama_pemohon ?? '_________' }} selaku KUASA/PEMILIK TANAH dan bertanggungjawab sepenuhnya, apabila dikemudian hari terjadi kekeliruan dalam menunjukkan batas dan letak tanah ini.</p>

    <p class="indent">Demikian berita acara ini dibuat untuk dapat dipergunakan seperlunya</p>

    <table style="width:100%; margin-top:2em; font-size:12pt;">
        <tr>
            <td style="width:50%; text-align:left; vertical-align:top;">
                <div style="font-weight:bold;">Petunjuk batas/letak</div>
                <table style="width:100%;">
                    <tr>
                        <td style="width:40%;">Nama</td>
                        <td style="width:5%;">:</td>
                        <td style="width:55%;"> {{ $peninjauan->skpt->nama_pemohon ?? '....................................................' }}</td>
                    </tr>
                    <tr>
                        <td>Alamat</td>
                        <td>:</td>
                        <td> {{ $peninjauan->skpt->alamat_pemohon ?? '....................................................' }}</td>
                    </tr>
                </table>
            </td>
            <td style="width:50%; text-align:left; vertical-align:top;">
                <div style="font-weight:bold;">yang melaksanakan pengukuran</div>
                <table style="width:100%;">
                    <tr>
                        <td style="width:40%;">Nama</td>
                        <td style="width:5%;">:</td>
                        <td style="width:55%;"> {{ $peninjauan->nama_petugas_ukur_1 ?? '....................................................' }}</td>
                    </tr>
                    <tr>
                        <td>Alamat</td>
                        <td>:</td>
                        <td> {{ $peninjauan->petugas_ukur_alamat_1 ?? '....................................................' }}</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <p style="font-size: 8pt;">*) jika para pemilik tanah yang berbatasan langsung tidak dapat hadir secara langsung dilapangan</p>
</body>
</html>
