{{-- resources/views/peninjauan/partials/edit-tab-data-pemohon.blade.php --}}

<!-- Data Pemohon/Peralihan Tab -->
<div class="tab-pane fade" id="data-pemohon" role="tabpanel">
    <div class="card">
        {{-- <div class="card-header">
            Data Peralihan Tanah
        </div> --}}
        <div class="card-body">
            <!-- Data Lokasi Section -->

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="jalan_gg_blok">Jalan/Gg/Blok</label>
                        <input type="text" class="form-control" id="jalan_gg_blok" name="jalan_gg_blok"
                               value="{{ old('jalan_gg_blok', $peninjauan->jalan_gg_blok) }}"
                               placeholder="Nama jalan/gang/blok">
                        @error('jalan_gg_blok')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="rt">RT</label>
                        <div class="">
                            <select name="rt" id="" class="form-control">
                                <option value="">-- Pilih RT --</option>
                                @for($i = 1; $i <= 20; $i++)
                                    <option value="{{ str_pad($i, 2, '0', STR_PAD_LEFT) }}"
                                        {{ old('rt', $peninjauan->rt) == str_pad($i, 2, '0', STR_PAD_LEFT) ? 'selected' : '' }}>
                                        {{ str_pad($i, 2, '0', STR_PAD_LEFT) }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                        @error('rt')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror

                    </div>
                </div>
                <div class="col-md-2">
                    <label for="">RW</label>
                    <input type="text" class="form-control" id="rw" name="rw"
                                   value="{{ old('rw', $peninjauan->rw) }}"
                                   placeholder="RW" >
                     @error('rw')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="kampung_kelurahan">Kampung/Kelurahan</label>
                        <select class="form-control @error('kampung_kelurahan') is-invalid @enderror"
                                            name="kampung_kelurahan">
                            <option value="">Pilih Kelurahan/Kampung</option>
                            @foreach($data_kampung as $kampung)
                                <option value="{{ $kampung->nama_kampung }}"
                                    {{ $peninjauan->kampung_kelurahan == $kampung->nama_kampung ? 'selected' : '' }}>
                                    {{ $kampung->nama_kampung }}
                                </option>
                            @endforeach
                        </select>
                        @error('kampung_kelurahan')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror

                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="kecamatan">Kecamatan</label>
                        <select class="form-control" id="kecamatan" name="kecamatan">
                            <option value="">-- Pilih Kecamatan --</option>
                            @foreach($kecamatans as $kecamatan)
                                <option value="{{ $kecamatan->id }}"
                                    {{ old('kecamatan', $peninjauan->kecamatan) == $kecamatan->id ? 'selected' : '' }}>
                                    {{ $kecamatan->nama_kecamatan }}
                                </option>
                            @endforeach
                        </select>
                        @error('kecamatan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="row mb-3">
                 <div class="col-6">
                    <div class="form-group">
                        <label for="luas">Luas</label>
                        <div class="d-flex align-items-center">
                            <input type="number" class="form-control" id="luas" name="luas"
                                   value="{{ old('luas', $peninjauan->luas) }}"
                                   placeholder="Luas tanah"  step="0.01">
                            <span class="ml-2">m²</span>
                        </div>
                        @error('luas')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="penggunaan_tanah_saat_ini">Penggunaan Tanah saat ini</label>
                        <input type="text" class="form-control" id="penggunaan_tanah_saat_ini" name="penggunaan_tanah"
                               value="{{ old('penggunaan_tanah', $peninjauan->penggunaan_tanah) }}"
                               placeholder="">
                        @error('penggunaan_tanah')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>

            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="tanda_batas">Tanda Batas Fisik</label>
                        <input type="text" class="form-control" id="tanda_batas" name="tanda_batas"
                               value="patok ulin 10x10 cm"
                               placeholder="Tanda batas" readonly>
                        @error('tanda_batas')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>
            <!-- Batas-Batas Section -->
            <h5 class="section-title">Batas</h5>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="batas_utara">Utara</label>
                        <input type="text" class="form-control" id="batas_utara" name="batas_utara"
                               value="{{ old('batas_utara', $peninjauan->batas_utara) }}"
                               placeholder="Batas utara">
                        @error('batas_utara')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="batas_timur">Timur</label>
                        <input type="text" class="form-control" id="batas_timur" name="batas_timur"
                               value="{{ old('batas_timur', $peninjauan->batas_timur) }}"
                               placeholder="Batas timur">
                        @error('batas_timur')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="batas_selatan">Selatan</label>
                        <input type="text" class="form-control" id="batas_selatan" name="batas_selatan"
                               value="{{ old('batas_selatan', $peninjauan->batas_selatan) }}"
                               placeholder="Batas selatan">
                        @error('batas_selatan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="batas_barat">Barat</label>
                        <input type="text" class="form-control" id="batas_barat" name="batas_barat"
                               value="{{ old('batas_barat', $peninjauan->batas_barat) }}"
                               placeholder="Batas barat">
                        @error('batas_barat')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>


            <hr>
            <!-- Hak Penguasaan Section -->
            {{-- <h5 class="section-title">Hak Yasan Patak D/C (Nomor, Persil, Klas)</h5> --}}


            <div class="row mb-3">
                <div class="col-6">
                    <div class="form-group">
                        <label for="hak_yasan_patok">Hak Yasan Patok D/C (nomor, Persil, klas)</label>
                        <input type="text" class="form-control" id="hak_yasan_patok" name="hak_yasan_patok"
                               value="{{ old('hak_yasan_patok', $peninjauan->hak_yasan_patok) }}"
                               placeholder="">
                        @error('hak_yasan_patok')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="sppt">SPPT (Tahun dan Nomor)</label>
                        <input type="text" class="form-control" id="sppt" name="sppt"
                               value="{{ old('sppt', $peninjauan->sppt) }}"
                               placeholder="Tahun dan nomor SPPT">
                        @error('sppt')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>


        </div>
        <!-- Form Actions -->
        <div class="card-footer d-flex justify-content-between">
            {{-- <button type="button" class="btn btn-secondary" onclick="previousTab()">
                ← Sebelumnya
            </button>
            <div>
                <button type="button" class="btn btn-secondary mr-2" onclick="saveDraft()">
                    💾 Simpan Draft
                </button>
                <button type="button" class="btn btn-primary" onclick="nextTab()">
                    Selanjutnya →
                </button>
            </div> --}}
        </div>
    </div>
</div>
