{{-- resources/views/peninjauan/partials/edit-tab-kesimpulan.blade.php --}}

<!-- Kesimpulan Tab -->
<div class="tab-pane fade" id="kesimpulan" role="tabpanel">
    <div class="card">
        <div class="header-section">
            PENINJAUAN<br>
            Kesimpulan dan Rekomendasi
        </div>
        <div class="card-body">
            <!-- Kesimpulan Peninjauan -->
            <h5 class="section-title">Kesimpulan Peninjauan Lapangan</h5>

            <div class="row mb-3">
                <div class="col-12">
                    <div class="form-group">
                        <label for="status_penguasaan_kesimpulan">Status Penguasaan Tanah</label>
                        <select class="form-control" id="status_penguasaan_kesimpulan" name="status_penguasaan_kesimpulan">
                            <option value="">-- Pilih Status --</option>
                            <option value="fisik" {{ old('status_penguasaan_kesimpulan', $peninjauan->status_penguasaan_kesimpulan) == 'fisik' ? 'selected' : '' }}>Penguasaan Fisik</option>
                            <option value="yuridis" {{ old('status_penguasaan_kesimpulan', $peninjauan->status_penguasaan_kesimpulan) == 'yuridis' ? 'selected' : '' }}>Penguasaan Yuridis</option>
                            <option value="fisik_yuridis" {{ old('status_penguasaan_kesimpulan', $peninjauan->status_penguasaan_kesimpulan) == 'fisik_yuridis' ? 'selected' : '' }}>Penguasaan Fisik dan Yuridis</option>
                            <option value="sengketa" {{ old('status_penguasaan_kesimpulan', $peninjauan->status_penguasaan_kesimpulan) == 'sengketa' ? 'selected' : '' }}>Ada Sengketa</option>
                            <option value="tidak_jelas" {{ old('status_penguasaan_kesimpulan', $peninjauan->status_penguasaan_kesimpulan) == 'tidak_jelas' ? 'selected' : '' }}>Tidak Jelas</option>
                        </select>
                        @error('status_penguasaan_kesimpulan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="luas_terukur_kesimpulan">Luas Tanah Terukur (m²)</label>
                        <input type="number" class="form-control" id="luas_terukur_kesimpulan" name="luas_terukur_kesimpulan"
                               value="{{ old('luas_terukur_kesimpulan', $peninjauan->luas_terukur_kesimpulan) }}"
                               placeholder="Luas dalam m²" readonly style="background: #f3f4f6;" step="0.01">
                        @error('luas_terukur_kesimpulan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="luas_surat_kesimpulan">Luas Tanah Menurut Surat (m²)</label>
                        <input type="number" class="form-control" id="luas_surat_kesimpulan" name="luas_surat_kesimpulan"
                               value="{{ old('luas_surat_kesimpulan', $peninjauan->luas_surat_kesimpulan) }}"
                               placeholder="Luas dalam m²" step="0.01">
                        @error('luas_surat_kesimpulan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-12">
                    <div class="form-group">
                        <label for="kesimpulan_status">Kesimpulan Status Tanah</label>
                        <textarea class="form-control" id="kesimpulan_status" name="kesimpulan_status" rows="4"
                                  placeholder="Tuliskan kesimpulan mengenai status tanah berdasarkan penelitian...">{{ old('kesimpulan_status', $peninjauan->kesimpulan_status) }}</textarea>
                        @error('kesimpulan_status')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Rekomendasi -->
            <h5 class="section-title">Rekomendasi</h5>

            <div class="row mb-3">
                <div class="col-12">
                    <div class="form-group">
                        <label>Rekomendasi Tindak Lanjut</label>
                        <div class="d-flex flex-column">
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="rekomendasi_skpt" id="rekomendasi_skpt" value="1"
                                       {{ old('rekomendasi_skpt', $peninjauan->rekomendasi_skpt) ? 'checked' : '' }}>
                                <label class="form-check-label" for="rekomendasi_skpt">Dapat diterbitkan SKPT</label>
                            </div>
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="rekomendasi_sertifikat" id="rekomendasi_sertifikat" value="1"
                                       {{ old('rekomendasi_sertifikat', $peninjauan->rekomendasi_sertifikat) ? 'checked' : '' }}>
                                <label class="form-check-label" for="rekomendasi_sertifikat">Dapat dilanjutkan proses sertifikat</label>
                            </div>
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="rekomendasi_mediasi" id="rekomendasi_mediasi" value="1"
                                       {{ old('rekomendasi_mediasi', $peninjauan->rekomendasi_mediasi) ? 'checked' : '' }}>
                                <label class="form-check-label" for="rekomendasi_mediasi">Perlu mediasi/penyelesaian sengketa</label>
                            </div>
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="rekomendasi_verifikasi" id="rekomendasi_verifikasi" value="1"
                                       {{ old('rekomendasi_verifikasi', $peninjauan->rekomendasi_verifikasi) ? 'checked' : '' }}>
                                <label class="form-check-label" for="rekomendasi_verifikasi">Perlu verifikasi data tambahan</label>
                            </div>
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="rekomendasi_tolak" id="rekomendasi_tolak" value="1"
                                       {{ old('rekomendasi_tolak', $peninjauan->rekomendasi_tolak) ? 'checked' : '' }}>
                                <label class="form-check-label" for="rekomendasi_tolak">Tidak dapat diproses (ditolak)</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-12">
                    <div class="form-group">
                        <label for="catatan_rekomendasi">Catatan Rekomendasi</label>
                        <textarea class="form-control" id="catatan_rekomendasi" name="catatan_rekomendasi" rows="4"
                                  placeholder="Tuliskan catatan atau rekomendasi tambahan...">{{ old('catatan_rekomendasi', $peninjauan->catatan_rekomendasi) }}</textarea>
                        @error('catatan_rekomendasi')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Data Petugas -->
            <h5 class="section-title">Data Petugas Peninjauan</h5>

            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="petugas1_nama">Nama Petugas 1</label>
                        <input type="text" class="form-control" id="petugas1_nama" name="petugas1_nama"
                               value="{{ old('petugas1_nama', $peninjauan->petugas1_nama) }}"
                               placeholder="Nama lengkap">
                        @error('petugas1_nama')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="petugas1_nip">NIP</label>
                        <input type="text" class="form-control" id="petugas1_nip" name="petugas1_nip"
                               value="{{ old('petugas1_nip', $peninjauan->petugas1_nip) }}"
                               placeholder="NIP">
                        @error('petugas1_nip')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="petugas1_jabatan">Jabatan</label>
                        <input type="text" class="form-control" id="petugas1_jabatan" name="petugas1_jabatan"
                               value="{{ old('petugas1_jabatan', $peninjauan->petugas1_jabatan) }}"
                               placeholder="Jabatan">
                        @error('petugas1_jabatan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="petugas2_nama">Nama Petugas 2</label>
                        <input type="text" class="form-control" id="petugas2_nama" name="petugas2_nama"
                               value="{{ old('petugas2_nama', $peninjauan->petugas2_nama) }}"
                               placeholder="Nama lengkap">
                        @error('petugas2_nama')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="petugas2_nip">NIP</label>
                        <input type="text" class="form-control" id="petugas2_nip" name="petugas2_nip"
                               value="{{ old('petugas2_nip', $peninjauan->petugas2_nip) }}"
                               placeholder="NIP">
                        @error('petugas2_nip')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="petugas2_jabatan">Jabatan</label>
                        <input type="text" class="form-control" id="petugas2_jabatan" name="petugas2_jabatan"
                               value="{{ old('petugas2_jabatan', $peninjauan->petugas2_jabatan) }}"
                               placeholder="Jabatan">
                        @error('petugas2_jabatan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Pengesahan -->
            <h5 class="section-title">Pengesahan</h5>

            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="tempat_pengesahan">Tempat</label>
                        <input type="text" class="form-control" id="tempat_pengesahan" name="tempat_pengesahan"
                               value="{{ old('tempat_pengesahan', $peninjauan->tempat_pengesahan) }}"
                               placeholder="Tempat pengesahan">
                        @error('tempat_pengesahan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="tanggal_pengesahan">Tanggal</label>
                        <input type="date" class="form-control" id="tanggal_pengesahan" name="tanggal_pengesahan"
                               value="{{ old('tanggal_pengesahan', $peninjauan->tanggal_pengesahan) }}">
                        @error('tanggal_pengesahan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="mengetahui_nama">Mengetahui - Nama</label>
                        <input type="text" class="form-control" id="mengetahui_nama" name="mengetahui_nama"
                               value="{{ old('mengetahui_nama', $peninjauan->mengetahui_nama) }}"
                               placeholder="Nama pejabat">
                        @error('mengetahui_nama')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="mengetahui_nip">NIP</label>
                        <input type="text" class="form-control" id="mengetahui_nip" name="mengetahui_nip"
                               value="{{ old('mengetahui_nip', $peninjauan->mengetahui_nip) }}"
                               placeholder="NIP">
                        @error('mengetahui_nip')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="mengetahui_jabatan">Jabatan</label>
                        <input type="text" class="form-control" id="mengetahui_jabatan" name="mengetahui_jabatan"
                               value="{{ old('mengetahui_jabatan', $peninjauan->mengetahui_jabatan) }}"
                               placeholder="Jabatan">
                        @error('mengetahui_jabatan')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Summary Box -->
            <div class="card bg-warning-light border-warning mb-3">
                <div class="card-body">
                    <h6 class="card-title text-warning-dark">📊 Ringkasan Data Peninjauan</h6>
                    <div class="row" style="font-size: 13px;">
                        <div class="col-md-6 mb-2">
                            <strong>Nomor BA Kesaksian:</strong>
                            <span id="summary_ba_kesaksian">{{ $peninjauan->nomor_ba_kesaksian ?? '-' }}</span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <strong>Tanggal Peninjauan:</strong>
                            <span id="summary_tanggal">{{ $peninjauan->ba_tanggal ?? '-' }}</span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <strong>Lokasi:</strong>
                            <span id="summary_lokasi">{{ $peninjauan->jalan_gg_blok ?? '-' }}</span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <strong>Luas Terukur:</strong>
                            <span id="summary_luas">{{ $peninjauan->luas ? $peninjauan->luas . ' m²' : '-' }}</span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <strong>Status Penguasaan:</strong>
                            <span id="summary_status">{{ $peninjauan->penguasaan_tanah ?? '-' }}</span>
                        </div>
                        <div class="col-md-6 mb-2">
                            <strong>Jumlah Koordinat:</strong>
                            <span id="summary_koordinat">-</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Form Actions -->
        <div class="card-footer d-flex justify-content-between">
            {{-- <button type="button" class="btn btn-secondary" onclick="previousTab()">
                ← Sebelumnya
            </button>
            <div>
                <button type="button" class="btn btn-secondary mr-2" onclick="saveDraft()">
                    💾 Simpan Draft
                </button>
                <button type="button" class="btn btn-secondary mr-2" onclick="previewForm()">
                    👁️ Preview
                </button>
                <button type="submit" class="btn btn-primary" onclick="submitForm(event)">
                    ✅ Update Data
                </button>
            </div> --}}
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Update summary data
    function updateSummary() {
        const baKesaksian = document.querySelector('input[name="nomor_ba_kesaksian"]')?.value || '-';
        const tanggal = document.querySelector('input[name="ba_tanggal"]')?.value || '-';
        const lokasi = document.querySelector('input[name="jalan_gg_blok"]')?.value || '-';
        const luas = document.querySelector('input[name="luas"]')?.value || '-';
        const status = document.querySelector('select[name="penguasaan_tanah"]')?.value || '-';

        const coordRows = document.querySelectorAll('#coordinatesList tr').length || 0;

        document.getElementById('summary_ba_kesaksian').textContent = baKesaksian;
        document.getElementById('summary_tanggal').textContent = tanggal;
        document.getElementById('summary_lokasi').textContent = lokasi;
        document.getElementById('summary_luas').textContent = luas ? luas + ' m²' : '-';
        document.getElementById('summary_status').textContent = status;
        document.getElementById('summary_koordinat').textContent = coordRows + ' titik';

        const luasTerukur = document.querySelector('input[name="luas"]')?.value;
        if (luasTerukur) {
            document.querySelector('input[name="luas_terukur_kesimpulan"]').value = luasTerukur;
        }
    }

    function previewForm() {
        const formData = {};
        document.querySelectorAll('input, textarea, select').forEach(element => {
            if (element.name && element.value) {
                if (element.type === 'checkbox') {
                    if (element.checked) {
                        formData[element.name] = element.value;
                    }
                } else {
                    formData[element.name] = element.value;
                }
            }
        });

        console.log('Preview Data:', formData);
        alert('Preview form akan membuka halaman baru dengan tampilan print-ready. (Fitur akan diimplementasikan)');
    }
</script>
@endpush
