@extends('admin-layouts.master')

@section('title', 'Role Details - ' . $role->display_name)

@section('content')
<style>
.card {
    border-radius: 8px;
    transition: all 0.3s ease;
}

.role-icon {
    flex-shrink: 0;
}

.badge {
    font-size: 0.75rem;
    font-weight: 500;
}

.list-group-item {
    border-left: 0 !important;
    border-right: 0 !important;
}

.list-group-item:first-child {
    border-top: 0 !important;
}

.list-group-item:last-child {
    border-bottom: 0 !important;
}

.accordion .card-header {
    background-color: transparent;
}

.btn-link {
    color: #333 !important;
}

.btn-link:hover {
    color: #4e73df !important;
    text-decoration: none;
}

.transition-icon {
    transition: transform 0.3s ease;
}

.btn-link:not(.collapsed) .transition-icon {
    transform: rotate(90deg);
}

.modal-content {
    border-radius: 8px;
}

.form-label {
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    text-transform: uppercase;
    margin-bottom: 0.25rem;
}

.border-right {
    border-right: 1px solid #e3e6f0 !important;
}

.permission-check-icon {
    width: 20px;
    height: 20px;
    min-width: 20px;
    background-color: #28a745;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-top: 2px;
}

.permission-item {
    transition: all 0.2s ease;
}

.permission-item:hover {
    background-color: #f8f9fa;
    border-radius: 4px;
    padding: 8px;
    margin: -8px;
}
</style>
<div class="container-fluid">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                    <!-- Role Icon -->
                    <div class="role-icon mr-3">
                        @if($role->name === 'superadmin')
                            <div class="bg-danger rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                <i class="fas fa-crown text-white fa-lg"></i>
                            </div>
                        @elseif($role->name === 'manager')
                            <div class="bg-warning rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                <i class="fas fa-user-tie text-white fa-lg"></i>
                            </div>
                        @elseif($role->name === 'resepsionis')
                            <div class="bg-info rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                <i class="fas fa-concierge-bell text-white fa-lg"></i>
                            </div>
                        @elseif($role->name === 'housekeeping')
                            <div class="bg-success rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                <i class="fas fa-broom text-white fa-lg"></i>
                            </div>
                        @else
                            <div class="bg-secondary rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                <i class="fas fa-user text-white fa-lg"></i>
                            </div>
                        @endif
                    </div>
                    <div>
                        <h2 class="mb-1 text-dark font-weight-bold">{{ $role->display_name }}</h2>
                        <div class="d-flex align-items-center">
                            <span class="text-muted mr-3">{{ $role->name }}</span>
                            @if($role->is_active)
                                <span class="badge badge-success px-3 py-1">
                                    <i class="fas fa-check mr-1"></i> Active
                                </span>
                            @else
                                <span class="badge badge-secondary px-3 py-1">
                                    <i class="fas fa-times mr-1"></i> Inactive
                                </span>
                            @endif
                        </div>
                    </div>
                </div>
                <div>
                    @permission('manage_roles')
                    <a href="{{ route('roles.edit', $role) }}" class="btn btn-warning btn-sm shadow-sm mr-2">
                        <i class="fas fa-edit mr-1"></i> Edit Role
                    </a>
                    @endpermission
                    <a href="{{ route('roles.index') }}" class="btn btn-light btn-sm shadow-sm">
                        <i class="fas fa-arrow-left mr-1"></i> Back to Roles
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Role Information Card -->
        <div class="col-md-4 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0 py-3">
                    <h6 class="mb-0 text-dark font-weight-semibold">
                        <i class="fas fa-info-circle text-primary mr-2"></i>
                        Role Information
                    </h6>
                </div>
                <div class="card-body">
                    <!-- Role Details -->
                    <div class="mb-4">
                        <label class="form-label font-weight-semibold text-muted small">ROLE NAME</label>
                        <p class="mb-0 h6">{{ $role->name }}</p>
                    </div>

                    <div class="mb-4">
                        <label class="form-label font-weight-semibold text-muted small">DISPLAY NAME</label>
                        <p class="mb-0 h6">{{ $role->display_name }}</p>
                    </div>

                    @if($role->description)
                    <div class="mb-4">
                        <label class="form-label font-weight-semibold text-muted small">DESCRIPTION</label>
                        <p class="mb-0 text-dark">{{ $role->description }}</p>
                    </div>
                    @endif

                    <div class="mb-4">
                        <label class="form-label font-weight-semibold text-muted small">STATUS</label>
                        <div>
                            @if($role->is_active)
                                <span class="badge badge-success px-3 py-2">
                                    <i class="fas fa-check mr-1"></i> Active
                                </span>
                            @else
                                <span class="badge badge-secondary px-3 py-2">
                                    <i class="fas fa-times mr-1"></i> Inactive
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label font-weight-semibold text-muted small">CREATED</label>
                        <p class="mb-0 text-dark">{{ $role->created_at->format('M d, Y') }}</p>
                        <small class="text-muted">{{ $role->created_at->diffForHumans() }}</small>
                    </div>

                    @if($role->updated_at->ne($role->created_at))
                    <div class="mb-4">
                        <label class="form-label font-weight-semibold text-muted small">LAST UPDATED</label>
                        <p class="mb-0 text-dark">{{ $role->updated_at->format('M d, Y') }}</p>
                        <small class="text-muted">{{ $role->updated_at->diffForHumans() }}</small>
                    </div>
                    @endif

                    <!-- Statistics -->
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="border-right">
                                <h4 class="mb-1 text-primary font-weight-bold">{{ $role->permissions->count() }}</h4>
                                <small class="text-muted">Permissions</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h4 class="mb-1 text-info font-weight-bold">{{ $role->users->count() }}</h4>
                            <small class="text-muted">Users</small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Assigned Users Card -->
            @if($role->users->count() > 0)
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-header bg-white border-bottom-0 py-3">
                    <h6 class="mb-0 text-dark font-weight-semibold">
                        <i class="fas fa-users text-info mr-2"></i>
                        Assigned Users ({{ $role->users->count() }})
                    </h6>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        @foreach($role->users->take(10) as $user)
                        <div class="list-group-item border-0 py-3">
                            <div class="d-flex align-items-center">
                                <div class="bg-light rounded-circle d-flex align-items-center justify-content-center mr-3" style="width: 35px; height: 35px;">
                                    <i class="fas fa-user text-muted"></i>
                                </div>
                                <div>
                                    <h6 class="mb-1 font-weight-semibold">{{ $user->name }}</h6>
                                    <small class="text-muted">{{ $user->email }}</small>
                                </div>
                            </div>
                        </div>
                        @endforeach
                        @if($role->users->count() > 10)
                        <div class="list-group-item border-0 py-2 text-center">
                            <small class="text-muted">and {{ $role->users->count() - 10 }} more users...</small>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            @endif
        </div>

        <!-- Permissions Card -->
        <div class="col-md-8 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0 py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <h6 class="mb-0 text-dark font-weight-semibold">
                            <i class="fas fa-key text-primary mr-2"></i>
                            Assigned Permissions ({{ $role->permissions->count() }})
                        </h6>
                        @permission('manage_roles')
                        <a href="{{ route('roles.edit', $role) }}" class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-edit mr-1"></i> Edit Permissions
                        </a>
                        @endpermission
                    </div>
                </div>
                <div class="card-body p-0">
                    @if($role->permissions->count() > 0)
                    <div class="accordion" id="permissionsAccordion">
                        @php
                            $groupedPermissions = $role->permissions->groupBy('group');
                        @endphp
                        @foreach($groupedPermissions as $group => $groupPermissions)
                        <div class="border-bottom">
                            <div class="card-header bg-white border-0 py-3" id="heading{{ $loop->index }}">
                                <div class="d-flex justify-content-between align-items-center">
                                    <button class="btn btn-link text-left p-0 text-decoration-none collapsed" 
                                            type="button" 
                                            data-toggle="collapse" 
                                            data-target="#collapse{{ $loop->index }}" 
                                            aria-expanded="false">
                                        <h6 class="mb-0 text-dark font-weight-semibold">
                                            <i class="fas fa-chevron-right mr-2 transition-icon"></i>
                                            {{ $group }}
                                        </h6>
                                    </button>
                                    <span class="badge badge-primary px-3 py-1">{{ $groupPermissions->count() }} permissions</span>
                                </div>
                            </div>
                            <div id="collapse{{ $loop->index }}" 
                                 class="collapse" 
                                 data-parent="#permissionsAccordion">
                                <div class="card-body pt-0 pb-3">
                                    <div class="row">
                                        @foreach($groupPermissions as $permission)
                                        <div class="col-md-6 mb-3">
                                            <div class="d-flex align-items-start">
                                                <div class="bg-success rounded-circle d-flex align-items-center justify-content-center mr-3 mt-1" style="width: 20px; height: 20px; min-width: 20px;">
                                                    <i class="fas fa-check text-white" style="font-size: 10px;"></i>
                                                </div>
                                                <div>
                                                    <h6 class="mb-1 font-weight-semibold text-dark">{{ $permission->display_name }}</h6>
                                                    <small class="text-muted">{{ $permission->name }}</small>
                                                    @if($permission->description)
                                                    <p class="mb-0 text-muted small mt-1">{{ $permission->description }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @else
                    <!-- Empty State -->
                    <div class="text-center py-5">
                        <i class="fas fa-key fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted mb-2">No Permissions Assigned</h5>
                        <p class="text-muted mb-3">This role doesn't have any permissions assigned.</p>
                        @permission('manage_roles')
                        <a href="{{ route('roles.edit', $role) }}" class="btn btn-primary">
                            <i class="fas fa-plus mr-1"></i> Assign Permissions
                        </a>
                        @endpermission
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    @permission('manage_roles')
    <div class="row">
        <div class="col-md-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('roles.index') }}" class="btn btn-light px-4">
                            <i class="fas fa-arrow-left mr-1"></i> Back to Roles
                        </a>
                        <div>
                            @if($role->name !== 'superadmin')
                            <button type="button" 
                                    class="btn btn-danger px-4 mr-2" 
                                    data-toggle="modal" 
                                    data-target="#deleteModal">
                                <i class="fas fa-trash mr-1"></i> Delete Role
                            </button>
                            @endif
                            <a href="{{ route('roles.edit', $role) }}" class="btn btn-primary px-4">
                                <i class="fas fa-edit mr-1"></i> Edit Role
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if($role->name !== 'superadmin')
    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow">
                <div class="modal-header border-bottom-0 bg-danger text-white">
                    <h6 class="modal-title">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        Confirm Delete
                    </h6>
                    <button type="button" class="close text-white" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center py-4">
                    <i class="fas fa-trash fa-3x text-danger mb-3"></i>
                    <h5 class="mb-2">Delete Role "{{ $role->display_name }}"?</h5>
                    <p class="text-muted mb-3">This action cannot be undone. All permissions associated with this role will be removed.</p>
                    @if($role->users->count() > 0)
                    <div class="alert alert-warning">
                        <strong>Warning:</strong> This role is currently assigned to {{ $role->users->count() }} user(s). 
                        Please reassign these users to other roles before deletion.
                    </div>
                    @endif
                </div>
                <div class="modal-footer border-top-0 d-flex justify-content-center">
                    <button type="button" class="btn btn-light px-4" data-dismiss="modal">Cancel</button>
                    @if($role->users->count() == 0)
                    <form action="{{ route('roles.destroy', $role) }}" method="POST" class="ml-2">
                        @csrf @method('DELETE')
                        <button type="submit" class="btn btn-danger px-4">
                            <i class="fas fa-trash mr-1"></i> Delete
                        </button>
                    </form>
                    @else
                    <button type="button" class="btn btn-danger px-4" disabled>
                        <i class="fas fa-ban mr-1"></i> Cannot Delete
                    </button>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @endif
    @endpermission
</div>

@push('styles')

@endpush

@push('scripts')
<script>
$(document).ready(function() {
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Auto expand first accordion if there are permissions
    @if($role->permissions->count() > 0)
    $('#collapse0').addClass('show');
    $('#heading0 button').removeClass('collapsed');
    @endif
});
</script>
@endpush
@endsection