@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Tambah Kategori Layanan</h1>
        <a href="{{ route('service-categories.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <!-- Form Card -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Form Kategori Layanan</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('service-categories.store') }}" method="POST">
                        @csrf
                        
                        <div class="form-group">
                            <label for="name">Nama Kategori <span class="text-danger">*</span></label>
                            <input type="text" 
                                   class="form-control @error('name') is-invalid @enderror" 
                                   id="name" 
                                   name="name" 
                                   value="{{ old('name') }}" 
                                   placeholder=""
                                   required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                Nama kategori harus unik dan deskriptif untuk memudahkan pengelompokan layanan.
                            </small>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan Kategori
                            </button>
                            <a href="{{ route('service-categories.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Help Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">Panduan</h6>
                </div>
                <div class="card-body">
                    <h6 class="text-primary">Tips Membuat Kategori:</h6>
                    <ul class="text-sm">
                        <li>Gunakan nama yang jelas dan mudah dipahami</li>
                        <li>Kelompokkan layanan berdasarkan jenis atau departemen</li>
                        <li>Hindari nama yang terlalu umum atau terlalu spesifik</li>
                        <li>Pastikan tidak ada duplikasi nama kategori</li>
                    </ul>
                    
                    <hr>
                    
                    <h6 class="text-primary">Contoh Kategori:</h6>
                    <div class="mb-2">
                        <span class="badge badge-primary">Food & Beverage</span>
                        <small class="d-block text-muted">Makanan, minuman, room service</small>
                    </div>
                    <div class="mb-2">
                        <span class="badge badge-success">Spa & Wellness</span>
                        <small class="d-block text-muted">Pijat, facial, treatment</small>
                    </div>
                    <div class="mb-2">
                        <span class="badge badge-info">Laundry</span>
                        <small class="d-block text-muted">Cuci, setrika, dry cleaning</small>
                    </div>
                    <div class="mb-2">
                        <span class="badge badge-warning">Transportation</span>
                        <small class="d-block text-muted">Airport shuttle, car rental</small>
                    </div>
                </div>
            </div>

            <!-- Statistics Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-success">Statistik Kategori</h6>
                </div>
                <div class="card-body">
                    <div class="text-center">
                        <div class="h4 mb-0 font-weight-bold text-primary">
                            {{ \App\Models\MsServiceCategory::count() }}
                        </div>
                        <div class="text-xs text-gray-600">Total Kategori Saat Ini</div>
                    </div>
                    
                    <hr>
                    
                    <div class="text-center">
                        <div class="h4 mb-0 font-weight-bold text-success">
                            {{ \App\Models\MsService::count() }}
                        </div>
                        <div class="text-xs text-gray-600">Total Layanan</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Auto focus on name input
    $('#name').focus();
    
    // Form validation
    $('form').on('submit', function(e) {
        const name = $('#name').val().trim();
        
        if (name.length < 3) {
            e.preventDefault();
            Swal.fire({
                icon: 'warning',
                title: 'Nama Terlalu Pendek',
                text: 'Nama kategori minimal 3 karakter'
            });
            return false;
        }
        
        if (name.length > 100) {
            e.preventDefault();
            Swal.fire({
                icon: 'warning',
                title: 'Nama Terlalu Panjang',
                text: 'Nama kategori maksimal 100 karakter'
            });
            return false;
        }
    });
});
</script>
@endpush
@endsection