@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Detail Kategori Layanan</h1>
        <a href="{{ route('service-categories.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <!-- Content Row -->
    <div class="row">
        <div class="col-lg-8">
            <!-- Detail Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Kategori</h6>
                </div>
                <div class="card-body">
                    <dl class="row">
                        <dt class="col-sm-4">Nama Kategori</dt>
                        <dd class="col-sm-8">{{ $serviceCategory->name }}</dd>

                        <dt class="col-sm-4">Tanggal Dibuat</dt>
                        <dd class="col-sm-8">{{ $serviceCategory->created_at->format('d M Y H:i') }}</dd>

                        <dt class="col-sm-4">Terakhir Diperbarui</dt>
                        <dd class="col-sm-8">{{ $serviceCategory->updated_at->format('d M Y H:i') }}</dd>
                    </dl>

                    <div class="mt-4">
                        <a href="{{ route('service-categories.edit', $serviceCategory->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> Edit Kategori
                        </a>
                        <a href="{{ route('service-categories.index') }}" class="btn btn-secondary">
                            <i class="fas fa-list"></i> Daftar Kategori
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Side Info -->
        <div class="col-lg-4">
            <!-- Statistik Kategori -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-success">Statistik Kategori</h6>
                </div>
                <div class="card-body">
                    <div class="text-center">
                        <div class="h4 mb-0 font-weight-bold text-primary">
                            {{ \App\Models\MsServiceCategory::count() }}
                        </div>
                        <div class="text-xs text-gray-600">Total Kategori</div>
                    </div>

                    <hr>

                    <div class="text-center">
                        <div class="h4 mb-0 font-weight-bold text-success">
                            {{ \App\Models\MsService::where('service_category_id', $serviceCategory->id)->count() }}
                        </div>
                        <div class="text-xs text-gray-600">Layanan dalam Kategori Ini</div>
                    </div>
                </div>
            </div>

            <!-- Tips -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">Panduan</h6>
                </div>
                <div class="card-body">
                    <ul class="text-sm mb-0">
                        <li>Nama kategori tidak boleh kosong atau duplikat</li>
                        <li>Edit kategori jika ada perubahan besar</li>
                        <li>Kategori sebaiknya menggambarkan jenis layanan</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
