@extends('admin-layouts.master')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Edit Kategori: {{ $serviceCategory->name }}</h1>
        <div class="btn-group">
            <a href="{{ route('service-categories.show', $serviceCategory) }}" class="btn btn-info">
                <i class="fas fa-eye"></i> Lihat Detail
            </a>
            <a href="{{ route('service-categories.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>

    <!-- Form Card -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Edit Kategori Layanan</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('service-categories.update', $serviceCategory) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="form-group">
                            <label for="name">Nama Kategori <span class="text-danger">*</span></label>
                            <input type="text" 
                                   class="form-control @error('name') is-invalid @enderror" 
                                   id="name" 
                                   name="name" 
                                   value="{{ old('name', $serviceCategory->name) }}" 
                                   placeholder="Contoh: Food & Beverage, Spa & Wellness, Laundry"
                                   required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                Nama kategori harus unik dan deskriptif untuk memudahkan pengelompokan layanan.
                            </small>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-warning">
                                <i class="fas fa-save"></i> Update Kategori
                            </button>
                            <a href="{{ route('service-categories.show', $serviceCategory) }}" class="btn btn-info">
                                <i class="fas fa-eye"></i> Lihat Detail
                            </a>
                            <a href="{{ route('service-categories.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Current Category Info -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">Informasi Saat Ini</h6>
                </div>
                <div class="card-body">
                    <table class="table table-borderless">
                        <tr>
                            <td><strong>Nama:</strong></td>
                            <td>{{ $serviceCategory->name }}</td>
                        </tr>
                        <tr>
                            <td><strong>Jumlah Layanan:</strong></td>
                            <td>
                                <span class="badge badge-{{ $serviceCategory->services->count() > 0 ? 'success' : 'secondary' }}">
                                    {{ $serviceCategory->services->count() }} layanan
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Dibuat:</strong></td>
                            <td>{{ $serviceCategory->created_at->format('d/m/Y H:i') }}</td>
                        </tr>
                        <tr>
                            <td><strong>Terakhir Update:</strong></td>
                            <td>{{ $serviceCategory->updated_at->format('d/m/Y H:i') }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- Services in Category -->
            @if($serviceCategory->services->isNotEmpty())
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-success">Layanan dalam Kategori</h6>
                </div>
                <div class="card-body">
                    @foreach($serviceCategory->services->take(5) as $service)
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div>
                            <a href="{{ route('services.show', $service) }}" class="text-primary">
                                {{ $service->name }}
                            </a>
                            <br>
                            <small class="text-muted">{{ $service->formatted_price }}/{{ $service->satuan }}</small>
                        </div>
                        <div class="text-right">
                            <strong class="text-success">{{ $service->formatted_price_with_ppn }}</strong>
                        </div>
                    </div>
                    @endforeach
                    
                    @if($serviceCategory->services->count() > 5)
                    <div class="text-center mt-3">
                        <a href="{{ route('services.index') }}?category_id={{ $serviceCategory->id }}" class="btn btn-sm btn-outline-success">
                            Lihat Semua ({{ $serviceCategory->services->count() }} layanan)
                        </a>
                    </div>
                    @endif
                </div>
            </div>
            @endif

            <!-- Warning Card -->
            @if($serviceCategory->services->count() > 0)
            <div class="card shadow mb-4 border-left-warning">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-warning">Perhatian</h6>
                </div>
                <div class="card-body">
                    <div class="text-warning">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>Kategori Memiliki Layanan</strong>
                    </div>
                    <p class="text-sm mt-2">
                        Kategori ini memiliki {{ $serviceCategory->services->count() }} layanan. 
                        Mengubah nama kategori akan mempengaruhi tampilan di semua layanan terkait.
                    </p>
                    <div class="text-sm">
                        <div class="text-success">✓ Nama kategori akan terupdate di semua layanan</div>
                        <div class="text-info">✓ Tidak mempengaruhi booking yang sudah ada</div>
                        <div class="text-warning">⚠ Pastikan nama baru tetap relevan</div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Quick Actions -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Quick Actions</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('services.create') }}?category_id={{ $serviceCategory->id }}" class="btn btn-success mb-2">
                            <i class="fas fa-plus"></i> Tambah Layanan
                        </a>
                        <a href="{{ route('services.index') }}?category_id={{ $serviceCategory->id }}" class="btn btn-info mb-2">
                            <i class="fas fa-list"></i> Lihat Layanan
                        </a>
                        <a href="{{ route('service-categories.show', $serviceCategory) }}" class="btn btn-secondary">
                            <i class="fas fa-eye"></i> Detail Kategori
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Auto focus on name input
    $('#name').focus().select();
    
    // Form validation
    $('form').on('submit', function(e) {
        const name = $('#name').val().trim();
        const originalName = '{{ $serviceCategory->name }}';
        
        if (name.length < 3) {
            e.preventDefault();
            Swal.fire({
                icon: 'warning',
                title: 'Nama Terlalu Pendek',
                text: 'Nama kategori minimal 3 karakter'
            });
            return false;
        }
        
        if (name.length > 100) {
            e.preventDefault();
            Swal.fire({
                icon: 'warning',
                title: 'Nama Terlalu Panjang',
                text: 'Nama kategori maksimal 100 karakter'
            });
            return false;
        }
        
        // Show confirmation if there are services in this category and name changed
        @if($serviceCategory->services->count() > 0)
        if (name !== originalName) {
            e.preventDefault();
            Swal.fire({
                title: 'Konfirmasi Perubahan',
                html: `
                    <div class="text-left">
                        <p>Kategori ini memiliki <strong>{{ $serviceCategory->services->count() }} layanan</strong>.</p>
                        <p>Mengubah nama kategori akan mempengaruhi tampilan di semua layanan terkait.</p>
                        <hr>
                        <strong>Nama Lama:</strong> ${originalName}<br>
                        <strong>Nama Baru:</strong> ${name}
                    </div>
                `,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#ffc107',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, Update!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    $('form')[0].submit();
                }
            });
            return false;
        }
        @endif
    });
});
</script>
@endpush
@endsection