@extends('admin-layouts.master')

@section('content')

<div class="container-fluid">
    <h1 class="h3 mb-2 text-gray-800">Tracking Claim</h1>

    @if($data->cek_resi??false)
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <strong>Nomor Resi Tidak Dapat Ditemukan !</strong> Silahkan cek kembali nomor resi anda.
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
    @endif
    <div class="row  justify-content-center align-items-center">
        <div class="col">
            <div class="card ">
                <div class="card-body">
                    <form action="{{url("tracking-claim/create")}}">
                        <div class="form-row">
                          <div class="col-12">
                            <label for="">Nomor Resi</label>
                            <input type="text" name="code" class="form-control" placeholder="Nomor Resi" value="{{$data->code}}" required>
                          </div>
                          
                        </div>
                        @if($data->id??false)
                        <div class="form-row mt-3">
                            <div class="col-12">
                              <label for="">Penerima Klaim</label>
                              <input type="text" name="" class="form-control" placeholder="" value="{{$data->regisKlaim->nama}}" disabled>
                            </div>
                        </div>
                        @endif
                        <div class="form-row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary mb-2 btn-block"><i class="fas fa-search"> Cari</i></button>
                              </div>
                        </div>
                      </form>
                </div>
            </div>
        </div>
    </div>
    @if($data->id??false)
    <div class="row mt-5">
        <div class="col">
            <div class="card">
                <div class="card-body">
                    <h5>Riwayat Resi</h5>
                    <div class="table-responsive">
                        <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>No Resi</th>
                                    <th>Status</th>
                                    <th>Tanggal</th>
                                </tr>
                            </thead>
                            
                            <tbody>
                                @foreach ($data->history_resi as $u)
                                <tr>
                                        
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $u->resi->code }}</td>
                                    <td>{{ $u->status }}</td>
                                    <td>{{ App\Libraries\MyLib::tgl_sql_to_indo($u->created_at->todatestring()) ?? '' }}</td>

                                </tr>
                                @endforeach
                                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>

@endsection