@extends('admin-layouts.master')

@section('title', 'User Management')

@section('content')
<style>
:root {
    --primary-color: #4e73df;
    --success-color: #1cc88a;
    --info-color: #36b9cc;
    --warning-color: #f6c23e;
    --danger-color: #e74a3b;
    --light-bg: #f8f9fc;
    --border-color: #e3e6f0;
}

.card {
    border-radius: 10px;
    border: none;
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
    transition: all 0.3s ease;
}

.table th {
    font-size: 0.85rem;
    letter-spacing: 0.5px;
    text-transform: uppercase;
    font-weight: 600;
    color: #5a5c69;
}

.btn-group .btn {
    border-radius: 6px !important;
    margin: 0 2px;
    transition: all 0.3s ease;
}

.btn-group .btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

.user-avatar {
    flex-shrink: 0;
}

.badge {
    font-size: 0.75rem;
    font-weight: 500;
    padding: 0.35rem 0.65rem;
    border-radius: 6px;
}

.badge-outline-secondary {
    color: #6c757d;
    border: 1px solid #6c757d;
    background-color: transparent;
}

.alert {
    border-radius: 8px;
    border: none;
}

.modal-content {
    border-radius: 10px;
    border: none;
}

.modal-backdrop {
    background-color: rgba(0, 0, 0, 0.5);
}

.table-hover tbody tr {
    transition: background-color 0.2s ease;
}

.table-hover tbody tr:hover {
    background-color: #f8f9fa;
}

.pagination .page-link {
    border-radius: 6px;
    margin: 0 2px;
    border: 1px solid var(--border-color);
    color: var(--primary-color);
    transition: all 0.3s ease;
}

.pagination .page-link:hover {
    background-color: var(--light-bg);
    transform: translateY(-2px);
}

.pagination .page-item.active .page-link {
    background-color: var(--primary-color);
    border-color: var(--primary-color);
    box-shadow: 0 2px 8px rgba(78, 115, 223, 0.3);
}

.input-group-text {
    border-radius: 0 6px 6px 0;
}

.form-control {
    border-radius: 6px 0 0 6px;
    border: 1px solid var(--border-color);
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.15);
}

.stats-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 0.3rem 2rem 0 rgba(58, 59, 69, 0.2);
}

.btn {
    transition: all 0.3s ease;
}

.btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}
</style>

<div class="container-fluid">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1 text-dark font-weight-bold">User Management</h2>
                    <p class="text-muted mb-0">Manage system users and their access rights</p>
                </div>
                @can('user.create')
                <div>
                    <a href="{{ route('users.create') }}" class="btn btn-primary btn-sm shadow-sm">
                        <i class="fas fa-plus mr-1"></i> Add New User
                    </a>
                </div>
                @endcan
            </div>
        </div>
    </div>

    <!-- Alert Messages -->
    @if(session('success'))
    <div class="row mb-3">
        <div class="col-md-12">
            <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
                <i class="fas fa-check-circle mr-2"></i>
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert">
                    <span>&times;</span>
                </button>
            </div>
        </div>
    </div>
    @endif

    @if(session('error'))
    <div class="row mb-3">
        <div class="col-md-12">
            <div class="alert alert-danger alert-dismissible fade show shadow-sm" role="alert">
                <i class="fas fa-exclamation-circle mr-2"></i>
                {{ session('error') }}
                <button type="button" class="close" data-dismiss="alert">
                    <span>&times;</span>
                </button>
            </div>
        </div>
    </div>
    @endif

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card stats-card">
                <div class="card-body text-center py-3">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center mr-3" style="width: 45px; height: 45px;">
                            <i class="fas fa-users text-white"></i>
                        </div>
                        <div>
                            <h4 class="mb-0 font-weight-bold text-primary">{{ $users->total() }}</h4>
                            <small class="text-muted">Total Users</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stats-card">
                <div class="card-body text-center py-3">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="bg-success rounded-circle d-flex align-items-center justify-content-center mr-3" style="width: 45px; height: 45px;">
                            <i class="fas fa-user-check text-white"></i>
                        </div>
                        <div>
                            <h4 class="mb-0 font-weight-bold text-success">{{ $users->where('email_verified_at', '!=', null)->count() }}</h4>
                            <small class="text-muted">Verified</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stats-card">
                <div class="card-body text-center py-3">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="bg-warning rounded-circle d-flex align-items-center justify-content-center mr-3" style="width: 45px; height: 45px;">
                            <i class="fas fa-user-tie text-white"></i>
                        </div>
                        <div>
                            <h4 class="mb-0 font-weight-bold text-warning">{{ $users->filter(function($user) { return $user->hasAnyRole(['superadmin', 'supervisor']); })->count() }}</h4>
                            <small class="text-muted">Admins</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card stats-card">
                <div class="card-body text-center py-3">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="bg-info rounded-circle d-flex align-items-center justify-content-center mr-3" style="width: 45px; height: 45px;">
                            <i class="fas fa-clock text-white"></i>
                        </div>
                        <div>
                            <h4 class="mb-0 font-weight-bold text-info">{{ $users->where('created_at', '>=', now()->subDays(7))->count() }}</h4>
                            <small class="text-muted">New (7 days)</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content Card -->
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header bg-white py-3">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <h6 class="mb-0 text-dark font-weight-bold">
                                <i class="fas fa-users text-primary mr-2"></i>
                                System Users
                            </h6>
                        </div>
                        <div class="col-md-6 text-right">
                            <div class="input-group" style="max-width: 250px; margin-left: auto;">
                                <input type="text" class="form-control form-control-sm" placeholder="Search users..." id="searchInput">
                                <div class="input-group-append">
                                    <span class="input-group-text bg-primary border-primary">
                                        <i class="fas fa-search text-white"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-body p-0">
                    @if($users->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover mb-0" id="usersTable">
                            <thead class="bg-light">
                                <tr>
                                    <th class="border-0 py-3 px-4">User</th>
                                    <th class="border-0 py-3">Primary Role</th>
                                    <th class="border-0 py-3">All Roles</th>
                                    <th class="border-0 py-3">Status</th>
                                    <th class="border-0 py-3">Joined</th>
                                    <th class="border-0 py-3 text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($users as $user)
                                <tr class="border-bottom">
                                    <td class="px-4 py-3">
                                        <div class="d-flex align-items-center">
                                            <div class="user-avatar mr-3">
                                                @if($user->profile_photo)
                                                    <img src="{{ asset('storage/' . $user->profile_photo) }}"
                                                        alt="{{ $user->name }}"
                                                        class="rounded-circle"
                                                        style="width: 40px; height: 40px; object-fit: cover; border: 2px solid #fff; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                                                @else
                                                    @if($user->hasRole('superadmin'))
                                                        <div class="bg-danger rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                            <i class="fas fa-crown text-white"></i>
                                                        </div>
                                                    @elseif($user->hasRole('supervisor'))
                                                        <div class="bg-warning rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                            <i class="fas fa-user-tie text-white"></i>
                                                        </div>
                                                    @elseif($user->hasRole('staff'))
                                                        <div class="bg-info rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                            <i class="fas fa-user-edit text-white"></i>
                                                        </div>
                                                    @elseif($user->hasRole('administrator'))
                                                        <div class="bg-success rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                            <i class="fas fa-user-cog text-white"></i>
                                                        </div>
                                                    @else
                                                        <div class="bg-secondary rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                            <i class="fas fa-user text-white"></i>
                                                        </div>
                                                    @endif
                                                @endif
                                            </div>
                                            <div>
                                                <h6 class="mb-1 font-weight-semibold text-dark">{{ $user->name }}</h6>
                                                <small class="text-muted d-block">{{ $user->username }}</small>
                                                <small class="text-muted">{{ $user->email }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="py-3">
                                        @if($user->primaryRole)
                                            @php
                                                $badgeClass = match($user->primaryRole->name) {
                                                    'superadmin' => 'danger',
                                                    'supervisor' => 'warning',
                                                    'staff' => 'info',
                                                    'administrator' => 'success',
                                                    'guest' => 'secondary',
                                                    default => 'secondary'
                                                };
                                            @endphp
                                            <span class="badge badge-{{ $badgeClass }} px-3 py-2">
                                                {{ $user->primaryRole->name }}
                                            </span>
                                        @else
                                            <span class="badge badge-light px-3 py-2">No Role</span>
                                        @endif
                                    </td>
                                    <td class="py-3">
                                        @if($user->roles->count() > 0)
                                            @foreach($user->roles->take(2) as $role)
                                                <span class="badge badge-outline-secondary mr-1 mb-1">{{ $role->name }}</span>
                                            @endforeach
                                            @if($user->roles->count() > 2)
                                                <span class="badge badge-light">+{{ $user->roles->count() - 2 }} more</span>
                                            @endif
                                        @else
                                            <span class="text-muted">No roles</span>
                                        @endif
                                    </td>
                                    <td class="py-3">
                                        @if($user->email_verified_at)
                                            <span class="badge badge-success px-3 py-2">
                                                <i class="fas fa-check mr-1"></i> Verified
                                            </span>
                                        @else
                                            <span class="badge badge-warning px-3 py-2">
                                                <i class="fas fa-clock mr-1"></i> Pending
                                            </span>
                                        @endif
                                    </td>
                                    <td class="py-3">
                                        <span class="text-dark">{{ $user->created_at->format('M d, Y') }}</span>
                                        <small class="text-muted d-block">{{ $user->created_at->diffForHumans() }}</small>
                                    </td>
                                    <td class="py-3 text-center">
                                        <div class="btn-group" role="group">
                                            @can('user.view')
                                            <a href="{{ route('users.show', $user) }}"
                                               class="btn btn-sm btn-outline-info"
                                               data-toggle="tooltip"
                                               data-placement="top"
                                               title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @endcan

                                            @can('user.edit')
                                            <a href="{{ route('users.edit', $user) }}"
                                               class="btn btn-sm btn-outline-warning"
                                               data-toggle="tooltip"
                                               data-placement="top"
                                               title="Edit User">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endcan

                                            @can('user.delete')
                                            @if(!$user->hasRole('superadmin') && $user->id !== auth()->id())
                                            <button type="button"
                                                    class="btn btn-sm btn-outline-danger btn-delete-user"
                                                    data-user-id="{{ $user->id }}"
                                                    data-user-name="{{ $user->name }}"
                                                    data-user-email="{{ $user->email }}"
                                                    data-toggle="tooltip"
                                                    data-placement="top"
                                                    title="Delete User">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                            @endif
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($users->hasPages())
                    <div class="card-footer bg-white py-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="text-muted small">
                                Showing {{ $users->firstItem() }} to {{ $users->lastItem() }} of {{ $users->total() }} results
                            </div>
                            {{ $users->links() }}
                        </div>
                    </div>
                    @endif

                    @else
                    <!-- Empty State -->
                    <div class="text-center py-5">
                        <i class="fas fa-users fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted mb-2">No Users Found</h5>
                        <p class="text-muted mb-3">There are no users registered in the system.</p>
                        @can('user.create')
                        <a href="{{ route('users.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus mr-1"></i> Create First User
                        </a>
                        @endcan
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Single Delete Modal (Outside Loop) -->
<div class="modal fade" id="deleteUserModal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content border-0 shadow">
            <div class="modal-header border-bottom-0 bg-danger text-white">
                <h6 class="modal-title">
                    <i class="fas fa-exclamation-triangle mr-2"></i>
                    Confirm Delete
                </h6>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body text-center py-4">
                <i class="fas fa-user-times fa-3x text-danger mb-3"></i>
                <h5 class="mb-2">Delete User "<span id="deleteUserName"></span>"?</h5>
                <p class="text-muted mb-2">Email: <span id="deleteUserEmail" class="font-weight-bold"></span></p>
                <p class="text-muted mb-0">This action cannot be undone. The user will lose access to the system immediately.</p>
                <div class="alert alert-warning mt-3 text-left">
                    <i class="fas fa-info-circle mr-2"></i>
                    <small>All data associated with this user will be permanently deleted.</small>
                </div>
            </div>
            <div class="modal-footer border-top-0 d-flex justify-content-center">
                <button type="button" class="btn btn-light px-4" data-dismiss="modal">Cancel</button>
                <form id="deleteUserForm" method="POST" class="ml-2">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger px-4">
                        <i class="fas fa-trash mr-1"></i> Delete
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();

    // Handle delete button click
    $('.btn-delete-user').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();

        const userId = $(this).data('user-id');
        const userName = $(this).data('user-name');
        const userEmail = $(this).data('user-email');

        // Update modal content
        $('#deleteUserName').text(userName);
        $('#deleteUserEmail').text(userEmail);

        // Update form action
        const deleteUrl = "{{ route('users.destroy', ':id') }}".replace(':id', userId);
        $('#deleteUserForm').attr('action', deleteUrl);

        // Show modal
        $('#deleteUserModal').modal('show');
    });

    // Clean up when modal is hidden
    $('#deleteUserModal').on('hidden.bs.modal', function () {
        $(this).find('form').trigger('reset');
        $('#deleteUserName').text('');
        $('#deleteUserEmail').text('');
    });

    // Search functionality
    $('#searchInput').on('keyup', function() {
        const value = $(this).val().toLowerCase();
        $('#usersTable tbody tr').filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
        });
    });

    // Auto hide alerts after 5 seconds
    setTimeout(function() {
        $('.alert').not('.alert-warning').fadeOut('slow');
    }, 5000);

    // Prevent multiple modal instances
    $(document).on('show.bs.modal', '.modal', function () {
        const zIndex = 1040 + (10 * $('.modal:visible').length);
        $(this).css('z-index', zIndex);
        setTimeout(function() {
            $('.modal-backdrop').not('.modal-stack').css('z-index', zIndex - 1).addClass('modal-stack');
        }, 0);
    });

    // Remove tooltip on button click
    $('[data-toggle="tooltip"]').on('click', function() {
        $(this).tooltip('hide');
    });

    // Add smooth hover effect to stats cards
    $('.stats-card').hover(
        function() {
            $(this).addClass('shadow-lg');
        },
        function() {
            $(this).removeClass('shadow-lg');
        }
    );
});
</script>
@endpush
@endsection
