@extends('admin-layouts.master')

@section('content')
<style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
    
    .profile-container {
        max-width: 800px;
        margin: 0 auto;
    }

    .profile-header {
        text-align: center;
        margin-bottom: 2rem;
    }

    .profile-header h1 {
        font-size: 2.5rem;
        font-weight: 700;
        color: #2c3e50;
        margin-bottom: 0.5rem;
        font-family: 'Inter', sans-serif;
    }

    .profile-header p {
        color: #6c757d;
        font-size: 1.1rem;
        font-weight: 400;
    }

    .profile-card {
        background: white;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        padding: 0;
        overflow: hidden;
        transition: all 0.3s ease;
        border: 1px solid #e9ecef;
    }

    .profile-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12);
    }

    .card-header-custom {
        background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
        color: white;
        padding: 2rem;
        text-align: center;
        border: none;
    }

    .avatar-container {
        position: relative;
        display: inline-block;
        margin-bottom: 1rem;
    }

    .avatar {
        width: 100px;
        height: 100px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 3rem;
        color: white;
        border: 4px solid rgba(255, 255, 255, 0.3);
    }

    .avatar-edit {
        position: absolute;
        bottom: 0;
        right: 0;
        width: 32px;
        height: 32px;
        background: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #007bff;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
    }

    .avatar-edit:hover {
        transform: scale(1.1);
        background: #007bff;
        color: white;
    }

    .card-title-custom {
        font-size: 1.5rem;
        font-weight: 600;
        margin: 0;
    }

    .card-subtitle-custom {
        opacity: 0.9;
        margin-top: 0.5rem;
    }

    .card-body-custom {
        padding: 2.5rem;
    }

    .form-section {
        margin-bottom: 2rem;
    }

    .section-title {
        font-size: 1.2rem;
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 1.5rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .section-title i {
        color: #007bff;
        font-size: 1.1rem;
    }

    .form-group-custom {
        margin-bottom: 1.5rem;
        position: relative;
    }

    .form-label-custom {
        font-weight: 500;
        color: #495057;
        margin-bottom: 0.5rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .form-label-custom i {
        color: #007bff;
        font-size: 0.9rem;
    }

    .form-label-custom.error {
        color: #dc3545;
    }

    .form-label-custom.error i {
        color: #dc3545;
    }

    .input-group-custom {
        position: relative;
    }

    .form-control-custom {
        border: 2px solid #e9ecef;
        border-radius: 12px;
        padding: 0.75rem 1rem;
        font-size: 1rem;
        transition: all 0.3s ease;
        background: #f8f9fa;
        width: 100%;
    }

    .form-control-custom:focus {
        border-color: #007bff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.15);
        background: white;
        transform: translateY(-2px);
        outline: none;
    }

    .form-control-custom.is-invalid {
        border-color: #dc3545;
        background: #fff5f5;
    }

    .form-control-custom.is-invalid:focus {
        border-color: #dc3545;
        box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.15);
    }

    .input-icon {
        position: absolute;
        right: 1rem;
        top: 50%;
        transform: translateY(-50%);
        color: #6c757d;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .input-icon:hover {
        color: #007bff;
    }

    .password-toggle {
        cursor: pointer;
    }

    .error-message {
        color: #dc3545;
        font-size: 0.875rem;
        margin-top: 0.5rem;
        display: flex;
        align-items: center;
        gap: 0.25rem;
    }

    .error-message i {
        font-size: 0.8rem;
    }

    .password-strength {
        margin-top: 0.5rem;
    }

    .strength-meter {
        height: 4px;
        background: #e9ecef;
        border-radius: 2px;
        overflow: hidden;
        margin-bottom: 0.5rem;
    }

    .strength-fill {
        height: 100%;
        transition: all 0.3s ease;
        border-radius: 2px;
    }

    .strength-weak { 
        background: #dc3545; 
        width: 25%; 
    }
    .strength-fair { 
        background: #ffc107; 
        width: 50%; 
    }
    .strength-good { 
        background: #28a745; 
        width: 75%; 
    }
    .strength-strong { 
        background: #007bff; 
        width: 100%; 
    }

    .strength-text {
        font-size: 0.8rem;
        font-weight: 500;
    }

    .form-actions {
        display: flex;
        gap: 1rem;
        justify-content: flex-end;
        align-items: center;
        margin-top: 2.5rem;
        padding-top: 2rem;
        border-top: 1px solid #e9ecef;
    }

    .btn-custom {
        padding: 0.75rem 2rem;
        border-radius: 12px;
        font-weight: 500;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        text-decoration: none;
    }

    .btn-primary-custom {
        background: #007bff;
        color: white;
    }

    .btn-primary-custom:hover {
        background: #0056b3;
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
        color: white;
        text-decoration: none;
    }

    .btn-secondary-custom {
        background: #6c757d;
        color: white;
    }

    .btn-secondary-custom:hover {
        background: #545b62;
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(108, 117, 125, 0.3);
        color: white;
        text-decoration: none;
    }

    .btn-custom:disabled {
        opacity: 0.6;
        cursor: not-allowed;
        transform: none;
    }

    .form-tips {
        background: #e7f3ff;
        border: 1px solid #b3d9ff;
        border-radius: 12px;
        padding: 1rem;
        margin-top: 1.5rem;
    }

    .form-tips h6 {
        color: #0056b3;
        font-weight: 600;
        margin-bottom: 0.75rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .form-tips ul {
        margin: 0;
        padding-left: 1.5rem;
        color: #0056b3;
    }

    .form-tips li {
        margin-bottom: 0.25rem;
        font-size: 0.9rem;
    }

    .save-indicator {
        position: fixed;
        top: 20px;
        right: 20px;
        background: #28a745;
        color: white;
        padding: 1rem 1.5rem;
        border-radius: 12px;
        box-shadow: 0 8px 25px rgba(40, 167, 69, 0.3);
        transform: translateX(100%);
        transition: all 0.3s ease;
        z-index: 1000;
    }

    .save-indicator.show {
        transform: translateX(0);
    }

    @media (max-width: 768px) {
        .card-body-custom {
            padding: 1.5rem;
        }

        .form-actions {
            flex-direction: column-reverse;
            align-items: stretch;
        }

        .btn-custom {
            width: 100%;
            justify-content: center;
        }
    }

    /* Loading animation */
    .btn-loading {
        position: relative;
        pointer-events: none;
    }

    .btn-loading::after {
        content: '';
        position: absolute;
        width: 16px;
        height: 16px;
        margin: auto;
        border: 2px solid transparent;
        border-top-color: currentColor;
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
</style>

<div class="container-fluid">
    <div class="profile-container">
        <!-- Header -->
        <div class="profile-header">
            <h1>Update Profile</h1>
            <p>Kelola informasi profil dan keamanan akun Anda</p>
        </div>

        <!-- Profile Card -->
        <div class="profile-card">
            <!-- Card Header -->
            <div class="card-header-custom">
                <div class="avatar-container">
                    <div class="avatar">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="avatar-edit">
                        <i class="fas fa-camera"></i>
                    </div>
                </div>
                <h3 class="card-title-custom">{{ $user->name }}</h3>
                <p class="card-subtitle-custom">Administrator</p>
            </div>

            <!-- Card Body -->
            <div class="card-body-custom">
                <form id="profileForm" action="{{ route('update.profile', $user) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <!-- Personal Information Section -->
                    <div class="form-section">
                        <h4 class="section-title">
                            <i class="fas fa-user-circle"></i>
                            Informasi Personal
                        </h4>

                        <div class="form-group-custom">
                            <label class="form-label-custom @error('name') error @enderror" for="name">
                                <i class="fas fa-user"></i>
                                Nama Lengkap
                            </label>
                            <div class="input-group-custom">
                                <input type="text" 
                                       id="name" 
                                       name="name" 
                                       class="form-control-custom @error('name') is-invalid @enderror" 
                                       value="{{ $user->name ?? old('name') }}"
                                       placeholder="Masukkan nama lengkap"
                                       required>
                                <div class="input-icon">
                                    <i class="fas fa-check text-success" style="display: none;"></i>
                                </div>
                            </div>
                            @error('name')
                                <div class="error-message">
                                    <i class="fas fa-exclamation-circle"></i>
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="form-group-custom">
                            <label class="form-label-custom @error('email') error @enderror" for="email">
                                <i class="fas fa-envelope"></i>
                                Email Address
                            </label>
                            <div class="input-group-custom">
                                <input type="email" 
                                       id="email" 
                                       name="email" 
                                       class="form-control-custom @error('email') is-invalid @enderror" 
                                       value="{{ $user->email ?? old('email') }}"
                                       placeholder="Masukkan email address"
                                       required>
                                <div class="input-icon">
                                    <i class="fas fa-check text-success" style="display: none;"></i>
                                </div>
                            </div>
                            @error('email')
                                <div class="error-message">
                                    <i class="fas fa-exclamation-circle"></i>
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <!-- Security Section -->
                    <div class="form-section">
                        <h4 class="section-title">
                            <i class="fas fa-shield-alt"></i>
                            Keamanan Akun
                        </h4>

                        <div class="form-group-custom">
                            <label class="form-label-custom @error('password') error @enderror" for="password">
                                <i class="fas fa-lock"></i>
                                Password Baru
                            </label>
                            <div class="input-group-custom">
                                <input type="password" 
                                       id="password" 
                                       name="password" 
                                       class="form-control-custom @error('password') is-invalid @enderror" 
                                       placeholder="Masukkan password baru (kosongkan jika tidak ingin mengubah)">
                                <div class="input-icon password-toggle">
                                    <i class="fas fa-eye"></i>
                                </div>
                            </div>
                            <div class="password-strength" style="display: none;">
                                <div class="strength-meter">
                                    <div class="strength-fill"></div>
                                </div>
                                <small class="strength-text">Kekuatan password: <span class="strength-level">Lemah</span></small>
                            </div>
                            @error('password')
                                <div class="error-message">
                                    <i class="fas fa-exclamation-circle"></i>
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="form-tips">
                            <h6>
                                <i class="fas fa-info-circle"></i>
                                Tips Keamanan Password
                            </h6>
                            <ul>
                                <li>Gunakan minimal 8 karakter</li>
                                <li>Kombinasi huruf besar, kecil, angka, dan simbol</li>
                                <li>Hindari informasi personal yang mudah ditebak</li>
                                <li>Ganti password secara berkala</li>
                            </ul>
                        </div>
                    </div>

                    <!-- Form Actions -->
                    <div class="form-actions">
                        <a href="{{ route('user.index') }}" class="btn-custom btn-secondary-custom">
                            <i class="fas fa-arrow-left"></i>
                            Kembali
                        </a>
                        <button type="submit" class="btn-custom btn-primary-custom" id="submitBtn">
                            <i class="fas fa-save"></i>
                            Simpan Perubahan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Save Success Indicator -->
<div class="save-indicator" id="saveIndicator">
    <i class="fas fa-check-circle"></i>
    Profile berhasil diperbarui!
</div>

<script>
$(document).ready(function() {
    // Animate card entrance
    $('.profile-card').css({
        'opacity': '0',
        'transform': 'translateY(30px)'
    }).animate({
        'opacity': '1'
    }, 600).css({
        'transform': 'translateY(0)',
        'transition': 'all 0.6s ease'
    });

    // Password toggle visibility
    $('.password-toggle').click(function() {
        const passwordField = $('#password');
        const icon = $(this).find('i');
        
        if (passwordField.attr('type') === 'password') {
            passwordField.attr('type', 'text');
            icon.removeClass('fa-eye').addClass('fa-eye-slash');
        } else {
            passwordField.attr('type', 'password');
            icon.removeClass('fa-eye-slash').addClass('fa-eye');
        }
    });

    // Real-time validation
    $('#name').on('input', function() {
        validateName($(this));
    });

    $('#email').on('input', function() {
        validateEmail($(this));
    });

    $('#password').on('input', function() {
        const value = $(this).val();
        if (value.length > 0) {
            $('.password-strength').show();
            checkPasswordStrength(value);
        } else {
            $('.password-strength').hide();
        }
        validatePassword($(this));
    });

    // Form submission with loading state
    $('#profileForm').on('submit', function(e) {
        const submitBtn = $('#submitBtn');
        const originalText = submitBtn.html();
        
        // Show loading state
        submitBtn.addClass('btn-loading').prop('disabled', true);
        submitBtn.html('<i class="fas fa-spinner fa-spin"></i> Menyimpan...');
        
        // Form will submit normally, this is just UI feedback
    });

    // Avatar edit click
    $('.avatar-edit').click(function() {
        alert('Fitur upload avatar akan segera tersedia');
    });

    @if(session('success'))
        showSaveSuccess();
    @endif
});

function validateName(field) {
    const value = field.val().trim();
    const isValid = value.length >= 2;
    
    toggleValidation(field, isValid, 'Nama harus diisi minimal 2 karakter');
    return isValid;
}

function validateEmail(field) {
    const value = field.val().trim();
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    const isValid = emailRegex.test(value);
    
    toggleValidation(field, isValid, 'Format email tidak valid');
    return isValid;
}

function validatePassword(field) {
    const value = field.val();
    
    if (value.length === 0) {
        toggleValidation(field, true, '');
        return true;
    }
    
    const isValid = value.length >= 8;
    toggleValidation(field, isValid, 'Password minimal 8 karakter');
    return isValid;
}

function toggleValidation(field, isValid, errorMessage) {
    const formGroup = field.closest('.form-group-custom');
    const icon = formGroup.find('.input-icon i');
    
    if (isValid) {
        field.removeClass('is-invalid');
        icon.removeClass('text-danger').addClass('text-success').show();
    } else {
        field.addClass('is-invalid');
        icon.removeClass('text-success').addClass('text-danger').show();
    }
}

function checkPasswordStrength(password) {
    let strength = 0;
    let strengthText = 'Lemah';
    let strengthClass = 'strength-weak';

    if (password.length >= 8) strength++;
    if (password.length >= 12) strength++;
    if (/[a-z]/.test(password)) strength++;
    if (/[A-Z]/.test(password)) strength++;
    if (/[0-9]/.test(password)) strength++;
    if (/[^A-Za-z0-9]/.test(password)) strength++;

    if (strength >= 6) {
        strengthText = 'Sangat Kuat';
        strengthClass = 'strength-strong';
    } else if (strength >= 4) {
        strengthText = 'Kuat';
        strengthClass = 'strength-good';
    } else if (strength >= 2) {
        strengthText = 'Sedang';
        strengthClass = 'strength-fair';
    }

    $('.strength-fill').removeClass('strength-weak strength-fair strength-good strength-strong')
                       .addClass(strengthClass);
    $('.strength-level').text(strengthText);
}

function showSaveSuccess() {
    const indicator = $('#saveIndicator');
    indicator.addClass('show');
    
    setTimeout(() => {
        indicator.removeClass('show');
    }, 3000);
}
</script>

@endsection