@extends('admin-layouts.master')

@section('title', 'User Details - ' . $user->name)

@section('content')
<style>
.card {
    border-radius: 8px;
    transition: all 0.3s ease;
}

.info-label {
    font-size: 0.85rem;
    font-weight: 600;
    color: #6c757d;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 0.5rem;
}

.info-value {
    font-size: 1rem;
    color: #2c3e50;
    font-weight: 500;
}

.user-avatar-large {
    width: 100px;
    height: 100px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content-center;
    font-size: 2.5rem;
}

.role-badge {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-size: 0.85rem;
    font-weight: 600;
    display: inline-flex;
    align-items: center;
    margin: 0.25rem;
}

.role-badge i {
    margin-right: 0.5rem;
}

.badge-superadmin {
    background-color: #dc3545;
    color: white;
}

.badge-supervisor {
    background-color: #ffc107;
    color: #000;
}

.badge-staff {
    background-color: #17a2b8;
    color: white;
}

.badge-administrator {
    background-color: #28a745;
    color: white;
}

.badge-guest {
    background-color: #6c757d;
    color: white;
}

.stat-card {
    border-left: 4px solid;
    border-radius: 8px;
    padding: 1.5rem;
    background: white;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
}

.stat-card.primary {
    border-color: #4e73df;
}

.stat-card.success {
    border-color: #28a745;
}

.stat-card.info {
    border-color: #17a2b8;
}

.stat-card.warning {
    border-color: #ffc107;
}

.timeline-item {
    padding-left: 2rem;
    position: relative;
    padding-bottom: 1.5rem;
}

.timeline-item::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 2px;
    background: #e3e6f0;
}

.timeline-item::after {
    content: '';
    position: absolute;
    left: -4px;
    top: 0;
    width: 10px;
    height: 10px;
    border-radius: 50%;
    background: #4e73df;
}

.timeline-item:last-child::before {
    display: none;
}

.permission-group {
    background: #f8f9fc;
    border-radius: 8px;
    padding: 1rem;
    margin-bottom: 1rem;
}

.permission-item {
    padding: 0.5rem;
    border-bottom: 1px solid #e3e6f0;
}

.permission-item:last-child {
    border-bottom: none;
}

.profile-photo-large {
    width: 150px;
    height: 150px;
    object-fit: cover;
    border-radius: 8px;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.verified-badge {
    position: absolute;
    top: 10px;
    right: 10px;
    background: #28a745;
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.75rem;
}

.section-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 1rem;
    display: flex;
    align-items: center;
}

.section-title i {
    margin-right: 0.5rem;
    color: #4e73df;
}
</style>

<div class="container-fluid">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                    @php
                        $avatarConfig = match(true) {
                            $user->hasRole('superadmin') => ['bg' => 'bg-danger', 'icon' => 'fa-crown'],
                            $user->hasRole('supervisor') => ['bg' => 'bg-warning', 'icon' => 'fa-user-tie'],
                            $user->hasRole('staff') => ['bg' => 'bg-info', 'icon' => 'fa-user-edit'],
                            $user->hasRole('administrator') => ['bg' => 'bg-success', 'icon' => 'fa-user-cog'],
                            $user->hasRole('guest') => ['bg' => 'bg-secondary', 'icon' => 'fa-user-clock'],
                            default => ['bg' => 'bg-secondary', 'icon' => 'fa-user']
                        };
                    @endphp
                    <div class="user-avatar-large {{ $avatarConfig['bg'] }} mr-3">
                        <i class="fas {{ $avatarConfig['icon'] }} text-white"></i>
                    </div>
                    <div>
                        <h2 class="mb-1 text-dark font-weight-bold">{{ $user->name }}</h2>
                        <p class="text-muted mb-0">
                            <i class="fas fa-at mr-1"></i>{{ $user->username }}
                            @if($user->email_verified_at)
                                <span class="badge badge-success ml-2">
                                    <i class="fas fa-check-circle"></i> Verified
                                </span>
                            @endif
                        </p>
                    </div>
                </div>
                <div>
                    @can('user.edit')
                    <a href="{{ route('users.edit', $user) }}" class="btn btn-primary btn-sm shadow-sm mr-2">
                        <i class="fas fa-edit mr-1"></i> Edit User
                    </a>
                    @endcan
                    <a href="{{ route('users.index') }}" class="btn btn-light btn-sm shadow-sm">
                        <i class="fas fa-arrow-left mr-1"></i> Back to Users
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Alert Messages -->
    @if(session('success'))
    <div class="row mb-3">
        <div class="col-md-12">
            <div class="alert alert-success alert-dismissible fade show shadow-sm border-0" role="alert">
                <i class="fas fa-check-circle mr-2"></i>
                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert">
                    <span>&times;</span>
                </button>
            </div>
        </div>
    </div>
    @endif

    <div class="row">
        <!-- Left Column -->
        <div class="col-md-8">
            <!-- Basic Information Card -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom-0 py-3">
                    <h6 class="section-title mb-0">
                        <i class="fas fa-user"></i>
                        Basic Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="info-label">Full Name</div>
                            <div class="info-value">{{ $user->name }}</div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="info-label">Username</div>
                            <div class="info-value">{{ $user->username }}</div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="info-label">Email Address</div>
                            <div class="info-value">
                                {{ $user->email }}
                                @if($user->email_verified_at)
                                    <small class="text-success d-block">
                                        <i class="fas fa-check-circle"></i>
                                        Verified {{ $user->email_verified_at->diffForHumans() }}
                                    </small>
                                @else
                                    <small class="text-warning d-block">
                                        <i class="fas fa-clock"></i>
                                        Not verified
                                    </small>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="info-label">Primary Role</div>
                            <div class="info-value">
                                @if($user->primaryRole)
                                    <span class="role-badge badge-{{ $user->primaryRole->name }}">
                                        @php
                                            $icon = match($user->primaryRole->name) {
                                                'superadmin' => 'fa-crown',
                                                'supervisor' => 'fa-user-tie',
                                                'staff' => 'fa-user-edit',
                                                'administrator' => 'fa-user-cog',
                                                'guest' => 'fa-user-clock',
                                                default => 'fa-user'
                                            };
                                        @endphp
                                        <i class="fas {{ $icon }}"></i>
                                        {{ $user->primaryRole->display_name }}
                                    </span>
                                @else
                                    <span class="text-muted">No primary role assigned</span>
                                @endif
                            </div>
                        </div>
                    </div>

                    @if($user->profile_photo)
                    <div class="row">
                        <div class="col-md-12">
                            <div class="info-label">Profile Photo</div>
                            <img src="{{ asset('storage/' . $user->profile_photo) }}"
                                 alt="{{ $user->name }}"
                                 class="profile-photo-large">
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Roles & Permissions Card -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom-0 py-3">
                    <h6 class="section-title mb-0">
                        <i class="fas fa-user-tag"></i>
                        Roles & Permissions
                    </h6>
                </div>
                <div class="card-body">
                    <div class="info-label mb-3">Assigned Roles ({{ $user->roles->count() }})</div>
                    <div class="mb-4">
                        @forelse($user->roles as $role)
                            @php
                                $badgeClass = match($role->name) {
                                    'superadmin' => 'badge-superadmin',
                                    'supervisor' => 'badge-supervisor',
                                    'staff' => 'badge-staff',
                                    'administrator' => 'badge-administrator',
                                    'guest' => 'badge-guest',
                                    default => 'badge-secondary'
                                };
                                $icon = match($role->name) {
                                    'superadmin' => 'fa-crown',
                                    'supervisor' => 'fa-user-tie',
                                    'staff' => 'fa-user-edit',
                                    'administrator' => 'fa-user-cog',
                                    'guest' => 'fa-user-clock',
                                    default => 'fa-user'
                                };
                            @endphp
                            <span class="role-badge {{ $badgeClass }}">
                                <i class="fas {{ $icon }}"></i>
                                {{ $role->display_name }}
                                @if($role->id === $user->primary_role_id)
                                    <small>(Primary)</small>
                                @endif
                            </span>
                        @empty
                            <p class="text-muted mb-0">No roles assigned</p>
                        @endforelse
                    </div>

                    @if($user->roles->count() > 0)
                    <div class="info-label mb-3">All Permissions</div>
                    @php
                        $allPermissions = $user->roles->flatMap->permissions->unique('id')->sortBy('name');
                        $groupedPermissions = $allPermissions->groupBy(function($permission) {
                            return explode('.', $permission->name)[0];
                        });
                    @endphp
                    @foreach($groupedPermissions as $group => $permissions)
                    <div class="permission-group">
                        <h6 class="font-weight-bold text-capitalize mb-3">
                            <i class="fas fa-shield-alt text-primary mr-2"></i>
                            {{ ucfirst($group) }} Permissions
                        </h6>
                        <div class="row">
                            @foreach($permissions as $permission)
                            <div class="col-md-6">
                                <div class="permission-item">
                                    <i class="fas fa-check text-success mr-2"></i>
                                    <span>{{ $permission->display_name }}</span>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endforeach
                    @endif
                </div>
            </div>
        </div>

        <!-- Right Column -->
        <div class="col-md-4">
            <!-- Account Statistics -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom-0 py-3">
                    <h6 class="section-title mb-0">
                        <i class="fas fa-chart-bar"></i>
                        Account Statistics
                    </h6>
                </div>
                <div class="card-body">
                    <div class="stat-card primary mb-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small">Assigned Roles</div>
                                <h4 class="mb-0 font-weight-bold">{{ $user->roles->count() }}</h4>
                            </div>
                            <div>
                                <i class="fas fa-user-tag fa-2x text-primary opacity-25"></i>
                            </div>
                        </div>
                    </div>

                    <div class="stat-card success mb-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small">Total Permissions</div>
                                <h4 class="mb-0 font-weight-bold">
                                    {{ $user->roles->flatMap->permissions->unique('id')->count() }}
                                </h4>
                            </div>
                            <div>
                                <i class="fas fa-shield-alt fa-2x text-success opacity-25"></i>
                            </div>
                        </div>
                    </div>

                    <div class="stat-card info mb-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small">Account Status</div>
                                <h6 class="mb-0 font-weight-bold">
                                    @if($user->email_verified_at)
                                        <span class="text-success">Active</span>
                                    @else
                                        <span class="text-warning">Pending</span>
                                    @endif
                                </h6>
                            </div>
                            <div>
                                <i class="fas fa-user-check fa-2x text-info opacity-25"></i>
                            </div>
                        </div>
                    </div>

                    <div class="stat-card warning">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <div class="text-muted small">Member Since</div>
                                <h6 class="mb-0 font-weight-bold">
                                    {{ $user->created_at->diffForHumans() }}
                                </h6>
                            </div>
                            <div>
                                <i class="fas fa-calendar-alt fa-2x text-warning opacity-25"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Account Timeline -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom-0 py-3">
                    <h6 class="section-title mb-0">
                        <i class="fas fa-history"></i>
                        Account Timeline
                    </h6>
                </div>
                <div class="card-body">
                    <div class="timeline-item">
                        <div class="text-muted small mb-1">{{ $user->created_at->format('M d, Y H:i') }}</div>
                        <div class="font-weight-semibold">Account Created</div>
                        <div class="small text-muted">User account was registered</div>
                    </div>

                    @if($user->email_verified_at)
                    <div class="timeline-item">
                        <div class="text-muted small mb-1">{{ $user->email_verified_at->format('M d, Y H:i') }}</div>
                        <div class="font-weight-semibold">Email Verified</div>
                        <div class="small text-muted">Email address was confirmed</div>
                    </div>
                    @endif

                    <div class="timeline-item">
                        <div class="text-muted small mb-1">{{ $user->updated_at->format('M d, Y H:i') }}</div>
                        <div class="font-weight-semibold">Last Updated</div>
                        <div class="small text-muted">Profile information was modified</div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            @can('user.edit')
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0 py-3">
                    <h6 class="section-title mb-0">
                        <i class="fas fa-bolt"></i>
                        Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    <a href="{{ route('users.edit', $user) }}" class="btn btn-primary btn-block mb-2">
                        <i class="fas fa-edit mr-2"></i> Edit User
                    </a>
                    @if(!$user->email_verified_at)
                    <button class="btn btn-success btn-block mb-2">
                        <i class="fas fa-envelope mr-2"></i> Resend Verification
                    </button>
                    @endif
                    @can('user.delete')
                    @if($user->id !== auth()->id())
                    <button class="btn btn-danger btn-block" onclick="confirmDelete('{{ $user->name }}')">
                        <i class="fas fa-trash mr-2"></i> Delete User
                    </button>
                    @endif
                    @endcan
                </div>
            </div>
            @endcan
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-hide alerts
    setTimeout(() => $('.alert').fadeOut('slow'), 5000);
});

function confirmDelete(userName) {
    if(confirm(`Are you sure you want to delete user "${userName}"? This action cannot be undone.`)) {
        // Submit delete form
        // You'll need to add the delete form in your blade file
    }
}
</script>
@endpush
@endsection
