<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>419 - Page Expired</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: #f8f9fa;
            min-height: 100vh;
            overflow-x: hidden;
        }

        .error-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }

        .floating-shapes {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 1;
        }

        .shape {
            position: absolute;
            background: rgba(0, 123, 255, 0.1);
            border-radius: 50%;
            animation: float 6s ease-in-out infinite;
        }

        .shape:nth-child(1) {
            width: 80px;
            height: 80px;
            top: 20%;
            left: 10%;
            animation-delay: -2s;
        }

        .shape:nth-child(2) {
            width: 120px;
            height: 120px;
            top: 60%;
            right: 10%;
            animation-delay: -4s;
        }

        .shape:nth-child(3) {
            width: 60px;
            height: 60px;
            bottom: 20%;
            left: 20%;
            animation-delay: -6s;
        }

        .shape:nth-child(4) {
            width: 100px;
            height: 100px;
            top: 10%;
            right: 30%;
            animation-delay: -1s;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(180deg); }
        }

        .error-card {
            background: white;
            border-radius: 20px;
            padding: 3rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
            max-width: 500px;
            width: 90%;
            position: relative;
            z-index: 10;
            transform: translateY(0);
            transition: all 0.3s ease;
            border: 1px solid #e9ecef;
        }

        .error-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }

        .error-illustration {
            width: 200px;
            height: 200px;
            margin: 0 auto 2rem;
            position: relative;
        }

        .clock-container {
            width: 160px;
            height: 160px;
            border: 6px solid #007bff;
            border-radius: 50%;
            position: relative;
            margin: 0 auto;
            background: #f8f9fa;
        }

        .clock-face {
            width: 100%;
            height: 100%;
            position: relative;
            border-radius: 50%;
        }

        .clock-hand {
            position: absolute;
            background: #007bff;
            transform-origin: bottom center;
            border-radius: 4px;
        }

        .hour-hand {
            width: 4px;
            height: 50px;
            top: 30px;
            left: 50%;
            margin-left: -2px;
            animation: rotate-hour 12s linear infinite;
        }

        .minute-hand {
            width: 3px;
            height: 65px;
            top: 15px;
            left: 50%;
            margin-left: -1.5px;
            animation: rotate-minute 1s linear infinite;
        }

        .center-dot {
            width: 12px;
            height: 12px;
            background: #007bff;
            border-radius: 50%;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 5;
        }

        .expired-icon {
            position: absolute;
            top: -10px;
            right: -10px;
            width: 50px;
            height: 50px;
            background: #dc3545;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            animation: pulse 2s infinite;
        }

        @keyframes rotate-hour {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        @keyframes rotate-minute {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }

        .error-code {
            font-size: 4rem;
            font-weight: 700;
            color: #007bff;
            margin-bottom: 1rem;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);
            animation: bounce 2s infinite;
        }

        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
            40% { transform: translateY(-10px); }
            60% { transform: translateY(-5px); }
        }

        .error-title {
            font-size: 1.8rem;
            font-weight: 600;
            color: #333;
            margin-bottom: 1rem;
        }

        .error-description {
            font-size: 1rem;
            color: #666;
            margin-bottom: 2rem;
            line-height: 1.6;
        }

        .action-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .btn-primary {
            background: #007bff;
            border: none;
            padding: 12px 30px;
            border-radius: 25px;
            font-weight: 500;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.4);
            background: #0056b3;
        }

        .btn-outline-secondary {
            border: 2px solid #007bff;
            color: #007bff;
            padding: 10px 28px;
            border-radius: 25px;
            font-weight: 500;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .btn-outline-secondary:hover {
            background: #007bff;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.4);
        }

        .progress-container {
            margin-top: 2rem;
            text-align: left;
        }

        .progress-label {
            font-size: 0.9rem;
            color: #666;
            margin-bottom: 0.5rem;
        }

        .progress {
            height: 6px;
            border-radius: 10px;
            background: #e9ecef;
        }

        .progress-bar {
            background: #007bff;
            border-radius: 10px;
            animation: progress-fill 3s ease-in-out infinite;
        }

        @keyframes progress-fill {
            0% { width: 0%; }
            50% { width: 100%; }
            100% { width: 0%; }
        }

        .footer-text {
            position: absolute;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            color: #6c757d;
            font-size: 0.9rem;
        }

        @media (max-width: 576px) {
            .error-card {
                padding: 2rem 1.5rem;
                margin: 20px;
            }
            
            .error-code {
                font-size: 3rem;
            }
            
            .error-title {
                font-size: 1.5rem;
            }
            
            .action-buttons {
                flex-direction: column;
                align-items: center;
            }
            
            .btn-primary, .btn-outline-secondary {
                width: 100%;
                max-width: 200px;
            }
        }
    </style>
</head>
<body>
    <!-- Floating Background Shapes -->
    <div class="floating-shapes">
        <div class="shape"></div>
        <div class="shape"></div>
        <div class="shape"></div>
        <div class="shape"></div>
    </div>

    <div class="container-fluid error-container">
        <div class="error-card">
            <!-- Error Illustration -->
            <div class="error-illustration">
                <div class="clock-container">
                    <div class="clock-face">
                        <div class="clock-hand hour-hand"></div>
                        <div class="clock-hand minute-hand"></div>
                        <div class="center-dot"></div>
                    </div>
                    <div class="expired-icon">
                        <i class="fas fa-exclamation"></i>
                    </div>
                </div>
            </div>

            <!-- Error Content -->
            <div class="error-code">419</div>
            <h1 class="error-title">Sesi Telah Berakhir</h1>
            <p class="error-description">
                Maaf, sesi Anda telah berakhir atau token keamanan tidak valid. 
                Hal ini terjadi untuk melindungi keamanan data Anda. 
                Silakan muat ulang halaman atau kembali ke beranda.
            </p>

            <!-- Action Buttons -->
            <div class="action-buttons">
                <button class="btn btn-primary" onclick="refreshPage()">
                    <i class="fas fa-redo-alt mr-2"></i>Muat Ulang
                </button>
                <button class="btn btn-outline-secondary" onclick="goHome()">
                    <i class="fas fa-home mr-2"></i>Beranda
                </button>
            </div>

            <!-- Progress Indicator -->
            <div class="progress-container">
                <div class="progress-label">
                    <i class="fas fa-shield-alt mr-2"></i>Memperbarui keamanan...
                </div>
                <div class="progress">
                    <div class="progress-bar" role="progressbar"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="footer-text">
        <i class="fas fa-lock mr-2"></i>Sistem Keamanan Aktif
    </div>

    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Refresh page function
        function refreshPage() {
            // Add loading state
            const btn = event.target.closest('.btn-primary');
            const originalText = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Memuat...';
            btn.disabled = true;
            
            // Simulate loading delay
            setTimeout(() => {
                window.location.reload();
            }, 1000);
        }

        // Go to home function
        function goHome() {
            const btn = event.target.closest('.btn-outline-secondary');
            const originalText = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Mengarahkan...';
            btn.disabled = true;
            
            setTimeout(() => {
                window.location.href = '/';
            }, 1000);
        }

        // Add interactive hover effects
        $(document).ready(function() {
            // Animate card entrance
            $('.error-card').css({
                'opacity': '0',
                'transform': 'translateY(50px) scale(0.9)'
            }).animate({
                'opacity': '1'
            }, 800).css({
                'transform': 'translateY(0) scale(1)',
                'transition': 'all 0.8s cubic-bezier(0.175, 0.885, 0.32, 1.275)'
            });

            // Interactive button effects
            $('.btn').hover(
                function() {
                    $(this).addClass('shadow-lg');
                },
                function() {
                    $(this).removeClass('shadow-lg');
                }
            );

            // Auto-refresh countdown (optional)
            let countdown = 60;
            const countdownInterval = setInterval(() => {
                countdown--;
                if (countdown <= 0) {
                    clearInterval(countdownInterval);
                    refreshPage();
                }
            }, 1000);

            // Add sparkle effect on hover
            $('.error-card').on('mouseenter', function() {
                createSparkles(this);
            });

            function createSparkles(container) {
                for (let i = 0; i < 5; i++) {
                    setTimeout(() => {
                        const sparkle = $('<div class="sparkle">✨</div>');
                        sparkle.css({
                            'position': 'absolute',
                            'top': Math.random() * 100 + '%',
                            'left': Math.random() * 100 + '%',
                            'pointer-events': 'none',
                            'animation': 'sparkle 1s ease-out forwards',
                            'z-index': '1000'
                        });
                        
                        $(container).append(sparkle);
                        
                        setTimeout(() => {
                            sparkle.remove();
                        }, 1000);
                    }, i * 200);
                }
            }

            // Add sparkle animation CSS
            $('<style>').text(`
                @keyframes sparkle {
                    0% {
                        transform: scale(0) rotate(0deg);
                        opacity: 1;
                    }
                    50% {
                        transform: scale(1) rotate(180deg);
                        opacity: 0.8;
                    }
                    100% {
                        transform: scale(0) rotate(360deg);
                        opacity: 0;
                    }
                }
            `).appendTo('head');
        });
    </script>
</body>
</html>