<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>503 - Service Unavailable</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: #f8f9fa;
            min-height: 100vh;
            overflow-x: hidden;
        }

        .error-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }

        .floating-shapes {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 1;
        }

        .shape {
            position: absolute;
            background: rgba(0, 123, 255, 0.1);
            border-radius: 50%;
            animation: float 6s ease-in-out infinite;
        }

        .shape:nth-child(1) {
            width: 80px;
            height: 80px;
            top: 20%;
            left: 10%;
            animation-delay: -2s;
        }

        .shape:nth-child(2) {
            width: 120px;
            height: 120px;
            top: 60%;
            right: 10%;
            animation-delay: -4s;
        }

        .shape:nth-child(3) {
            width: 60px;
            height: 60px;
            bottom: 20%;
            left: 20%;
            animation-delay: -6s;
        }

        .shape:nth-child(4) {
            width: 100px;
            height: 100px;
            top: 10%;
            right: 30%;
            animation-delay: -1s;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(180deg); }
        }

        .error-card {
            background: white;
            border-radius: 20px;
            padding: 3rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
            max-width: 550px;
            width: 90%;
            position: relative;
            z-index: 10;
            transform: translateY(0);
            transition: all 0.3s ease;
            border: 1px solid #e9ecef;
        }

        .error-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }

        .error-illustration {
            width: 200px;
            height: 200px;
            margin: 0 auto 2rem;
            position: relative;
        }

        .server-container {
            width: 140px;
            height: 180px;
            background: #343a40;
            border-radius: 15px;
            position: relative;
            margin: 0 auto;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .server-rack {
            position: absolute;
            width: 90%;
            height: 25px;
            background: #495057;
            border-radius: 3px;
            left: 50%;
            transform: translateX(-50%);
        }

        .server-rack:nth-child(1) { top: 15px; }
        .server-rack:nth-child(2) { top: 50px; }
        .server-rack:nth-child(3) { top: 85px; }
        .server-rack:nth-child(4) { top: 120px; }

        .server-lights {
            position: absolute;
            width: 8px;
            height: 8px;
            border-radius: 50%;
            top: 50%;
            transform: translateY(-50%);
        }

        .light-1 { 
            left: 10px; 
            background: #dc3545;
            animation: blink-red 1s infinite;
        }
        .light-2 { 
            left: 25px; 
            background: #ffc107;
            animation: blink-yellow 1.5s infinite;
        }
        .light-3 { 
            left: 40px; 
            background: #6c757d;
        }

        @keyframes blink-red {
            0%, 50% { opacity: 1; }
            51%, 100% { opacity: 0.3; }
        }

        @keyframes blink-yellow {
            0%, 60% { opacity: 1; }
            61%, 100% { opacity: 0.3; }
        }

        .server-screen {
            position: absolute;
            width: 80%;
            height: 30px;
            background: #000;
            border-radius: 5px;
            top: 150px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Courier New', monospace;
            font-size: 8px;
            color: #28a745;
            overflow: hidden;
        }

        .terminal-text {
            animation: type 3s steps(20) infinite;
            white-space: nowrap;
        }

        @keyframes type {
            0% { width: 0; }
            50% { width: 100%; }
            100% { width: 0; }
        }

        .maintenance-icon {
            position: absolute;
            top: -15px;
            right: -15px;
            width: 60px;
            height: 60px;
            background: #007bff;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            animation: pulse 2s infinite;
            box-shadow: 0 5px 15px rgba(0, 123, 255, 0.4);
        }

        .tools-floating {
            position: absolute;
            animation: float-tools 4s ease-in-out infinite;
        }

        .tool-1 {
            top: -20px;
            left: -20px;
            font-size: 20px;
            color: #6c757d;
            animation-delay: -1s;
        }

        .tool-2 {
            bottom: -20px;
            right: -30px;
            font-size: 18px;
            color: #6c757d;
            animation-delay: -2s;
        }

        @keyframes float-tools {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-10px) rotate(10deg); }
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }

        .error-code {
            font-size: 4rem;
            font-weight: 700;
            color: #007bff;
            margin-bottom: 1rem;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);
            animation: bounce 2s infinite;
        }

        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
            40% { transform: translateY(-10px); }
            60% { transform: translateY(-5px); }
        }

        .error-title {
            font-size: 1.8rem;
            font-weight: 600;
            color: #333;
            margin-bottom: 1rem;
        }

        .error-description {
            font-size: 1rem;
            color: #666;
            margin-bottom: 2rem;
            line-height: 1.6;
        }

        .action-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .btn-primary {
            background: #007bff;
            border: none;
            padding: 12px 30px;
            border-radius: 25px;
            font-weight: 500;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.4);
            background: #0056b3;
        }

        .btn-outline-secondary {
            border: 2px solid #007bff;
            color: #007bff;
            padding: 10px 28px;
            border-radius: 25px;
            font-weight: 500;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .btn-outline-secondary:hover {
            background: #007bff;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.4);
        }

        .status-container {
            margin-top: 2rem;
            text-align: left;
        }

        .status-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0.75rem;
            margin-bottom: 0.5rem;
            background: #f8f9fa;
            border-radius: 8px;
            border-left: 4px solid #007bff;
        }

        .status-item:last-child {
            margin-bottom: 0;
        }

        .status-label {
            display: flex;
            align-items: center;
            font-size: 0.9rem;
            color: #495057;
        }

        .status-label i {
            margin-right: 0.5rem;
            width: 16px;
        }

        .status-indicator {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            animation: pulse-status 2s infinite;
        }

        .status-down { background: #dc3545; }
        .status-maintenance { background: #007bff; }
        .status-checking { background: #6c757d; }

        @keyframes pulse-status {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }

        .maintenance-info {
            margin-top: 1.5rem;
            padding: 1.5rem;
            background: #e7f3ff;
            border: 1px solid #b3d9ff;
            border-radius: 15px;
            text-align: left;
        }

        .maintenance-info h6 {
            color: #0056b3;
            margin-bottom: 1rem;
            font-weight: 600;
            display: flex;
            align-items: center;
        }

        .maintenance-info h6 i {
            margin-right: 0.5rem;
        }

        .maintenance-timeline {
            margin: 0;
        }

        .timeline-item {
            display: flex;
            align-items: center;
            margin-bottom: 0.75rem;
            font-size: 0.9rem;
            color: #0056b3;
        }

        .timeline-item:last-child {
            margin-bottom: 0;
        }

        .timeline-item i {
            margin-right: 0.75rem;
            width: 16px;
            color: #007bff;
        }

        .refresh-timer {
            margin-top: 1.5rem;
            text-align: center;
            padding: 1rem;
            background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
            border-radius: 10px;
            border: 1px solid #90caf9;
        }

        .refresh-label {
            font-size: 0.9rem;
            color: #1976d2;
            margin-bottom: 0.5rem;
            font-weight: 500;
        }

        .refresh-countdown {
            font-size: 1.5rem;
            font-weight: 700;
            color: #1976d2;
        }

        .footer-text {
            position: absolute;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            color: #6c757d;
            font-size: 0.9rem;
        }

        @media (max-width: 576px) {
            .error-card {
                padding: 2rem 1.5rem;
                margin: 20px;
            }
            
            .error-code {
                font-size: 3rem;
            }
            
            .error-title {
                font-size: 1.5rem;
            }
            
            .action-buttons {
                flex-direction: column;
                align-items: center;
            }
            
            .btn-primary, .btn-outline-secondary {
                width: 100%;
                max-width: 200px;
            }

            .status-item {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.5rem;
            }
        }
    </style>
</head>
<body>
    <!-- Floating Background Shapes -->
    <div class="floating-shapes">
        <div class="shape"></div>
        <div class="shape"></div>
        <div class="shape"></div>
        <div class="shape"></div>
    </div>

    <div class="container-fluid error-container">
        <div class="error-card">
            <!-- Error Illustration -->
            <div class="error-illustration">
                <div class="server-container">
                    <div class="server-rack">
                        <div class="server-lights light-1"></div>
                        <div class="server-lights light-2"></div>
                        <div class="server-lights light-3"></div>
                    </div>
                    <div class="server-rack">
                        <div class="server-lights light-1"></div>
                        <div class="server-lights light-2"></div>
                        <div class="server-lights light-3"></div>
                    </div>
                    <div class="server-rack">
                        <div class="server-lights light-1"></div>
                        <div class="server-lights light-2"></div>
                        <div class="server-lights light-3"></div>
                    </div>
                    <div class="server-rack">
                        <div class="server-lights light-1"></div>
                        <div class="server-lights light-2"></div>
                        <div class="server-lights light-3"></div>
                    </div>
                    <div class="server-screen">
                        <div class="terminal-text">MAINTENANCE MODE</div>
                    </div>
                    <div class="maintenance-icon">
                        <i class="fas fa-tools"></i>
                    </div>
                    <div class="tools-floating tool-1">
                        <i class="fas fa-wrench"></i>
                    </div>
                    <div class="tools-floating tool-2">
                        <i class="fas fa-cog"></i>
                    </div>
                </div>
            </div>

            <!-- Error Content -->
            <div class="error-code">503</div>
            <h1 class="error-title">Layanan Tidak Tersedia</h1>
            <p class="error-description">
                Maaf, server sedang dalam pemeliharaan atau mengalami gangguan sementara. 
                Tim kami sedang bekerja keras untuk mengembalikan layanan secepat mungkin. 
                Terima kasih atas kesabaran Anda.
            </p>

            <!-- Server Status -->
            <div class="status-container">
                <div class="status-item">
                    <div class="status-label">
                        <i class="fas fa-server"></i>
                        Web Server
                    </div>
                    <div class="status-indicator status-maintenance"></div>
                </div>
                <div class="status-item">
                    <div class="status-label">
                        <i class="fas fa-database"></i>
                        Database
                    </div>
                    <div class="status-indicator status-checking"></div>
                </div>
                <div class="status-item">
                    <div class="status-label">
                        <i class="fas fa-cloud"></i>
                        API Services
                    </div>
                    <div class="status-indicator status-down"></div>
                </div>
            </div>

            <!-- Maintenance Information -->
            <div class="maintenance-info">
                <h6><i class="fas fa-calendar-alt"></i>Jadwal Pemeliharaan:</h6>
                <div class="maintenance-timeline">
                    <div class="timeline-item">
                        <i class="fas fa-clock"></i>
                        Dimulai: Hari ini, 02:00 WIB
                    </div>
                    <div class="timeline-item">
                        <i class="fas fa-hourglass-half"></i>
                        Estimasi selesai: 06:00 WIB
                    </div>
                    <div class="timeline-item">
                        <i class="fas fa-tools"></i>
                        Jenis: Update sistem & optimasi database
                    </div>
                    <div class="timeline-item">
                        <i class="fas fa-shield-alt"></i>
                        Dampak: Layanan tidak tersedia sementara
                    </div>
                </div>
            </div>

            <!-- Auto Refresh Timer -->
            <div class="refresh-timer">
                <div class="refresh-label">
                    <i class="fas fa-sync-alt mr-2"></i>Halaman akan dimuat ulang otomatis dalam:
                </div>
                <div class="refresh-countdown" id="refreshCountdown">30</div>
            </div>

            <!-- Action Buttons -->
            <div class="action-buttons">
                <button class="btn btn-primary" onclick="checkStatus()">
                    <i class="fas fa-sync-alt mr-2"></i>Periksa Status
                </button>
                <button class="btn btn-outline-secondary" onclick="getUpdates()">
                    <i class="fas fa-bell mr-2"></i>Dapatkan Update
                </button>
            </div>
        </div>
    </div>

    <div class="footer-text">
        <i class="fas fa-wrench mr-2"></i>Sistem Maintenance Mode
    </div>

    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/js/bootstrap.bundle.min.js"></script>
    
    <script>
        let refreshTime = 30;
        let refreshInterval;

        // Auto refresh countdown
        function startRefreshCountdown() {
            const countdownElement = document.getElementById('refreshCountdown');
            
            refreshInterval = setInterval(() => {
                refreshTime--;
                countdownElement.textContent = refreshTime;
                
                if (refreshTime <= 0) {
                    clearInterval(refreshInterval);
                    window.location.reload();
                }
            }, 1000);
        }

        // Check status function
        function checkStatus() {
            const btn = event.target.closest('.btn-primary');
            const originalText = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Memeriksa...';
            btn.disabled = true;
            
            // Simulate status check
            setTimeout(() => {
                // Reset countdown
                clearInterval(refreshInterval);
                refreshTime = 30;
                document.getElementById('refreshCountdown').textContent = refreshTime;
                startRefreshCountdown();
                
                btn.innerHTML = originalText;
                btn.disabled = false;
                
                // Show status update
                showStatusUpdate();
            }, 2000);
        }

        // Get updates function
        function getUpdates() {
            const btn = event.target.closest('.btn-outline-secondary');
            const originalText = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Menghubungi...';
            btn.disabled = true;
            
            setTimeout(() => {
                btn.innerHTML = '<i class="fas fa-check mr-2"></i>Terdaftar';
                
                setTimeout(() => {
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                }, 2000);
            }, 1500);
        }

        // Show status update notification
        function showStatusUpdate() {
            const notification = $(`
                <div class="alert alert-info alert-dismissible fade show" role="alert" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
                    <i class="fas fa-info-circle mr-2"></i>
                    <strong>Update Status:</strong> Pemeliharaan masih berlangsung. Estimasi selesai dalam 2 jam.
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            `);
            
            $('body').append(notification);
            
            setTimeout(() => {
                notification.alert('close');
            }, 5000);
        }

        // Initialize page
        $(document).ready(function() {
            // Start refresh countdown
            startRefreshCountdown();

            // Animate card entrance
            $('.error-card').css({
                'opacity': '0',
                'transform': 'translateY(50px) scale(0.9)'
            }).animate({
                'opacity': '1'
            }, 800).css({
                'transform': 'translateY(0) scale(1)',
                'transition': 'all 0.8s cubic-bezier(0.175, 0.885, 0.32, 1.275)'
            });

            // Interactive button effects
            $('.btn').hover(
                function() {
                    if (!$(this).prop('disabled')) {
                        $(this).addClass('shadow-lg');
                    }
                },
                function() {
                    $(this).removeClass('shadow-lg');
                }
            );

            // Add gear sparkle effect on hover
            $('.error-card').on('mouseenter', function() {
                createSparkles(this);
            });

            function createSparkles(container) {
                const icons = ['⚙️', '🔧', '🛠️', '⚡'];
                
                for (let i = 0; i < 4; i++) {
                    setTimeout(() => {
                        const sparkle = $(`<div class="sparkle">${icons[i]}</div>`);
                        sparkle.css({
                            'position': 'absolute',
                            'top': Math.random() * 100 + '%',
                            'left': Math.random() * 100 + '%',
                            'pointer-events': 'none',
                            'animation': 'sparkle 1.5s ease-out forwards',
                            'z-index': '1000',
                            'font-size': '1.2rem'
                        });
                        
                        $(container).append(sparkle);
                        
                        setTimeout(() => {
                            sparkle.remove();
                        }, 1500);
                    }, i * 300);
                }
            }

            // Add sparkle animation CSS
            $('<style>').text(`
                @keyframes sparkle {
                    0% {
                        transform: scale(0) rotate(0deg);
                        opacity: 1;
                    }
                    50% {
                        transform: scale(1) rotate(180deg);
                        opacity: 0.8;
                    }
                    100% {
                        transform: scale(0) rotate(360deg);
                        opacity: 0;
                    }
                }
            `).appendTo('head');

            // Simulate random status changes
            setInterval(() => {
                const indicators = $('.status-indicator');
                const randomIndex = Math.floor(Math.random() * indicators.length);
                const indicator = $(indicators[randomIndex]);
                
                // Flash briefly
                indicator.addClass('status-checking');
                setTimeout(() => {
                    indicator.removeClass('status-checking');
                }, 500);
            }, 8000);
        });
    </script>
</body>
</html>