<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Daftar Invoice - {{ $summary['period'] }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 11px;
            margin: 0;
            padding: 15px;
            line-height: 1.3;
        }
        
        .header {
            text-align: center;
            margin-bottom: 25px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }
        
        .header h1 {
            font-size: 18px;
            margin: 0;
            color: #333;
        }
        
        .header h2 {
            font-size: 14px;
            margin: 5px 0;
            color: #666;
        }
        
        .header p {
            margin: 3px 0;
            color: #888;
            font-size: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
            font-size: 10px;
        }
        
        table, th, td {
            border: 1px solid #333;
        }
        
        th {
            background-color: #f5f5f5;
            padding: 6px 4px;
            text-align: center;
            font-weight: bold;
            font-size: 9px;
        }
        
        td {
            padding: 4px;
            font-size: 9px;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-end {
            text-align: right;
        }
        
        .table-total {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        
        .footer {
            margin-top: 20px;
            padding-top: 10px;
            border-top: 1px solid #ccc;
            text-align: center;
            font-size: 9px;
            color: #666;
        }
        
        @media print {
            body {
                margin: 0;
                padding: 10px;
            }
            
            table {
                page-break-inside: auto;
            }
            
            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
            
            thead {
                display: table-header-group;
            }
            
            tfoot {
                display: table-footer-group;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <h1>LAPORAN PENDAPATAN HOTEL</h1>
        <h2>Daftar Invoice</h2>
        <p>Periode: {{ $summary['period'] }}</p>
        <p>Dicetak pada: {{ \Carbon\Carbon::now()->format('d M Y H:i') }}</p>
        @if($status !== 'all')
        <p>Status: {{ ucfirst($status) }}</p>
        @endif
    </div>

    <!-- Invoice List Table -->
    <table>
        <thead>
            <tr>
                <th style="width: 3%;">No</th>
                <th style="width: 15%;">Nama</th>
                <th style="width: 12%;">Tipe dan Nomor Kamar</th>
                <th style="width: 10%;">Tgl Check In</th>
                <th style="width: 10%;">Tgl Check Out</th>
                <th style="width: 6%;">Lama Inap</th>
                <th style="width: 10%;">Harga</th>
                <th style="width: 10%;">Biaya</th>
                <th style="width: 8%;">Pajak</th>
                <th style="width: 12%;">Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($invoices as $index => $invoice)
            @php
                $booking = $invoice->booking;
                $guest = $booking->guest ?? null;
                $bookingDetail = $booking->bookingDetails->first();
                $room = $bookingDetail->room ?? null;
                $roomType = $room->typeRoom ?? null;
                
                $checkIn = $booking->check_in_date ? \Carbon\Carbon::parse($booking->check_in_date) : null;
                $checkOut = $booking->check_out_date ? \Carbon\Carbon::parse($booking->check_out_date) : null;
                $lamaInap = ($checkIn && $checkOut) ? $checkIn->diffInDays($checkOut) : 0;
                
                $hargaPerMalam = $bookingDetail->price_per_night ?? 0;
                $totalBiaya = $invoice->room_total + $invoice->services_total;
            @endphp
            <tr>
                <td class="text-center">{{ $index + 1 }}</td>
                <td>{{ $guest->name ?? '-' }}</td>
                <td class="text-center">
                    @if($room && $roomType)
                        {{ $room->room_number }}- {{ $roomType->name }}
                    @else
                        -
                    @endif
                </td>
                <td class="text-center">{{ $checkIn ? $checkIn->format('d/m/Y') : '-' }}</td>
                <td class="text-center">{{ $checkOut ? $checkOut->format('d/m/Y') : '-' }}</td>
                <td class="text-center">{{ $lamaInap }}</td>
                <td class="text-right">{{ number_format($hargaPerMalam, 0, ',', '.') }}</td>
                <td class="text-right">{{ number_format($totalBiaya, 0, ',', '.') }}</td>
                <td class="text-right">{{ number_format($invoice->tax_amount, 0, ',', '.') }}</td>
                <td class="text-right"><strong>{{ number_format($invoice->grand_total, 0, ',', '.') }}</strong></td>
            </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr class="table-total">
                <td colspan="6" class="text-center"><strong>TOTAL</strong></td>
                <td class="text-right"><strong>{{ number_format($invoices->sum(function($invoice) { return $invoice->booking->bookingDetails->sum('price_per_night'); }), 0, ',', '.') }}</strong></td>
                <td class="text-right"><strong>{{ number_format($invoices->sum('room_total') + $invoices->sum('services_total'), 0, ',', '.') }}</strong></td>
                <td class="text-right"><strong>{{ number_format($invoices->sum('tax_amount'), 0, ',', '.') }}</strong></td>
                <td class="text-right"><strong>{{ number_format($invoices->sum('grand_total'), 0, ',', '.') }}</strong></td>
            </tr>
        </tfoot>
    </table>

    <!-- Summary -->
    <div style="margin-top: 20px;">
        <table style="width: 50%; border: none;">
            <tr style="border: none;">
                <td style="border: none; padding: 5px 0;">Total Invoice:</td>
                <td style="border: none; padding: 5px 0; text-align: right;"><strong>{{ $summary['total_invoices'] }}</strong></td>
            </tr>
            <tr style="border: none;">
                <td style="border: none; padding: 5px 0;">Total Pendapatan:</td>
                <td style="border: none; padding: 5px 0; text-align: right;"><strong>Rp {{ number_format($summary['total_revenue'], 0, ',', '.') }}</strong></td>
            </tr>
        </table>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>Daftar Invoice - Sistem Manajemen Hotel</p>
        <p>Tanggal cetak: {{ \Carbon\Carbon::now()->format('d M Y H:i:s') }}</p>
    </div>
</body>
</html>