<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Laporan Pendapatan - {{ $summary['period'] }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
            line-height: 1.4;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        
        .header h1 {
            font-size: 20px;
            margin: 0;
            color: #333;
        }
        
        .header h2 {
            font-size: 16px;
            margin: 5px 0;
            color: #666;
        }
        
        .header p {
            margin: 5px 0;
            color: #888;
        }
        
        .summary-section {
            margin-bottom: 25px;
        }
        
        .summary-boxes {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }
        
        .summary-box {
            width: 23%;
            border: 1px solid #ddd;
            padding: 15px;
            text-align: center;
            background-color: #f9f9f9;
        }
        
        .summary-box h3 {
            margin: 0 0 5px 0;
            font-size: 18px;
            color: #333;
        }
        
        .summary-box p {
            margin: 0;
            font-size: 11px;
            color: #666;
        }
        
        .breakdown-section {
            display: flex;
            justify-content: space-between;
            margin-bottom: 25px;
        }
        
        .breakdown-table {
            width: 48%;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        table, th, td {
            border: 1px solid #ddd;
        }
        
        th {
            background-color: #f5f5f5;
            padding: 8px;
            text-align: left;
            font-weight: bold;
            font-size: 11px;
        }
        
        td {
            padding: 6px 8px;
            font-size: 11px;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-end {
            text-align: right;
        }
        
        .table-total {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        
        .section-title {
            font-size: 14px;
            font-weight: bold;
            margin: 20px 0 10px 0;
            color: #333;
            border-bottom: 1px solid #ccc;
            padding-bottom: 5px;
        }
        
        .status-badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: bold;
        }
        
        .status-paid {
            background-color: #d4edda;
            color: #155724;
        }
        
        .status-pending {
            background-color: #fff3cd;
            color: #856404;
        }
        
        .status-cancelled {
            background-color: #f8d7da;
            color: #721c24;
        }
        
        .status-overdue {
            background-color: #d1ecf1;
            color: #0c5460;
        }
        
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ccc;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        
        .page-break {
            page-break-before: always;
        }
        
        @media print {
            body {
                margin: 0;
                padding: 15px;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <h1>LAPORAN PENDAPATAN HOTEL</h1>
        <h2>Periode: {{ $summary['period'] }}</h2>
        <p>Dicetak pada: {{ \Carbon\Carbon::now()->format('d M Y H:i') }}</p>
        @if($status !== 'all')
        <p>Status: {{ ucfirst($status) }}</p>
        @endif
    </div>

    <!-- Summary Section -->
    <div class="summary-section">
        <div class="section-title">RINGKASAN PENDAPATAN</div>
        <div class="summary-boxes">
            <div class="summary-box">
                <h3>Rp {{ number_format($summary['total_revenue'], 0, ',', '.') }}</h3>
                <p>Total Pendapatan</p>
            </div>
            <div class="summary-box">
                <h3>{{ $summary['total_invoices'] }}</h3>
                <p>Total Invoice</p>
            </div>
            <div class="summary-box">
                <h3>Rp {{ number_format($summary['average_invoice_value'], 0, ',', '.') }}</h3>
                <p>Rata-rata per Invoice</p>
            </div>
            <div class="summary-box">
                <h3>Rp {{ number_format($summary['total_tax'], 0, ',', '.') }}</h3>
                <p>Total Pajak</p>
            </div>
        </div>
    </div>

    <!-- Breakdown Section -->
    <div class="breakdown-section">
        <div class="breakdown-table">
            <div class="section-title">RINCIAN PENDAPATAN</div>
            <table>
                <tbody>
                    <tr>
                        <td>Pendapatan Kamar</td>
                        <td class="text-right">Rp {{ number_format($summary['total_room_revenue'], 0, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <td>Pendapatan Layanan</td>
                        <td class="text-right">Rp {{ number_format($summary['total_service_revenue'], 0, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <td>Diskon</td>
                        <td class="text-right">- Rp {{ number_format($summary['total_discount'], 0, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <td>Pajak (PPN)</td>
                        <td class="text-right">Rp {{ number_format($summary['total_tax'], 0, ',', '.') }}</td>
                    </tr>
                    <tr class="table-total">
                        <td><strong>Total Pendapatan</strong></td>
                        <td class="text-right"><strong>Rp {{ number_format($summary['total_revenue'], 0, ',', '.') }}</strong></td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <div class="breakdown-table">
            <div class="section-title">STATUS PEMBAYARAN</div>
            <table>
                <tbody>
                    <tr>
                        <td>Lunas</td>
                        <td class="text-right">Rp {{ number_format($summary['paid_amount'], 0, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <td>Pending</td>
                        <td class="text-right">Rp {{ number_format($summary['pending_amount'], 0, ',', '.') }}</td>
                    </tr>
                    <tr>
                        <td>Jatuh Tempo</td>
                        <td class="text-right">Rp {{ number_format($summary['overdue_amount'], 0, ',', '.') }}</td>
                    </tr>
                    <tr class="table-total">
                        <td><strong>Total</strong></td>
                        <td class="text-right"><strong>Rp {{ number_format($summary['total_revenue'], 0, ',', '.') }}</strong></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Revenue by Room Type -->
    @if($revenueByRoomType->count() > 0)
    <div class="section-title">PENDAPATAN PER TIPE KAMAR</div>
    <table>
        <thead>
            <tr>
                <th>Tipe Kamar</th>
                <th class="text-center">Jumlah Booking</th>
                <th class="text-right">Total Pendapatan</th>
                <th class="text-right">Rata-rata per Booking</th>
                <th class="text-center">Persentase</th>
            </tr>
        </thead>
        <tbody>
            @foreach($revenueByRoomType as $roomType)
            <tr>
                <td>{{ $roomType->room_type }}</td>
                <td class="text-center">{{ $roomType->booking_count }}</td>
                <td class="text-right">Rp {{ number_format($roomType->total_revenue, 0, ',', '.') }}</td>
                <td class="text-right">Rp {{ number_format($roomType->avg_revenue, 0, ',', '.') }}</td>
                <td class="text-center">
                    {{ number_format(($summary['total_room_revenue'] > 0 ? ($roomType->total_revenue / $summary['total_room_revenue']) * 100 : 0), 1) }}%
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @endif

    <!-- Page Break for Invoice Details -->
    <div class="page-break"></div>

    <!-- Detailed Invoice List -->
    <div class="section-title">DETAIL INVOICE</div>
    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>No. Invoice</th>
                <th>Tanggal</th>
                <th>Tamu</th>
                <th>Check-in</th>
                <th>Check-out</th>
                <th>Kamar</th>
                <th>Layanan</th>
                <th>Diskon</th>
                <th>Pajak</th>
                <th>Total</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($invoices as $index => $invoice)
            <tr>
                <td class="text-center">{{ $index + 1 }}</td>
                <td>{{ $invoice->invoice_number }}</td>
                <td>{{ \Carbon\Carbon::parse($invoice->invoice_date)->format('d/m/Y') }}</td>
                <td>{{ $invoice->booking->guest->name ?? '-' }}</td>
                <td>{{ $invoice->booking->check_in_date ? \Carbon\Carbon::parse($invoice->booking->check_in_date)->format('d/m/Y') : '-' }}</td>
                <td>{{ $invoice->booking->check_out_date ? \Carbon\Carbon::parse($invoice->booking->check_out_date)->format('d/m/Y') : '-' }}</td>
                <td class="text-right">{{ number_format($invoice->room_total, 0, ',', '.') }}</td>
                <td class="text-right">{{ number_format($invoice->services_total, 0, ',', '.') }}</td>
                <td class="text-right">{{ number_format($invoice->discount_amount, 0, ',', '.') }}</td>
                <td class="text-right">{{ number_format($invoice->tax_amount, 0, ',', '.') }}</td>
                <td class="text-right"><strong>{{ number_format($invoice->grand_total, 0, ',', '.') }}</strong></td>
                <td>
                    @switch($invoice->status)
                        @case('paid')
                            <span class="status-badge status-paid">Lunas</span>
                            @break
                        @case('pending')
                            <span class="status-badge status-pending">Pending</span>
                            @break
                        @case('cancelled')
                            <span class="status-badge status-cancelled">Dibatalkan</span>
                            @break
                        @case('overdue')
                            <span class="status-badge status-overdue">Jatuh Tempo</span>
                            @break
                        @default
                            <span class="status-badge">{{ ucfirst($invoice->status) }}</span>
                    @endswitch
                </td>
            </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr class="table-total">
                <td colspan="6" class="text-right"><strong>TOTAL:</strong></td>
                <td class="text-right"><strong>{{ number_format($invoices->sum('room_total'), 0, ',', '.') }}</strong></td>
                <td class="text-right"><strong>{{ number_format($invoices->sum('services_total'), 0, ',', '.') }}</strong></td>
                <td class="text-right"><strong>{{ number_format($invoices->sum('discount_amount'), 0, ',', '.') }}</strong></td>
                <td class="text-right"><strong>{{ number_format($invoices->sum('tax_amount'), 0, ',', '.') }}</strong></td>
                <td class="text-right"><strong>{{ number_format($invoices->sum('grand_total'), 0, ',', '.') }}</strong></td>
                <td></td>
            </tr>
        </tfoot>
    </table>

    <!-- Footer -->
    <div class="footer">
        <p>Laporan ini digenerate secara otomatis oleh Sistem Manajemen Hotel</p>
        <p>Tanggal cetak: {{ \Carbon\Carbon::now()->format('d M Y H:i:s') }}</p>
    </div>
</body>
</html>