<?php

use App\Http\Controllers\KecamatanController;
use App\Http\Controllers\KampungController;
use App\Http\Controllers\RtrwController;
use App\Http\Controllers\ActivityLogController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PenerbitanSKPTController;
use App\Http\Controllers\PenerbitanSpmptController;
use App\Http\Controllers\PeninjauanController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SKPTController;
use App\Http\Controllers\SpSiptController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Clear Cache Route
Route::get('/clear-cache', function () {
    Artisan::call('optimize:clear');
    return "Cache cleared successfully";
})->middleware(['auth', 'permission:clear_cache']);

// Redirect root to login
Route::get('/', function () {
    return redirect()->route('login');
});

// Authentication Routes
Auth::routes();

// ================================
// AUTHENTICATED ROUTES
// ================================
Route::middleware(['auth', 'verified'])->group(function () {

    // ================================
    // HOME / DASHBOARD
    // ================================
    Route::get('/home', [HomeController::class, 'index'])->name('home');
    Route::post('/filter-skpt', [HomeController::class, 'filterSkpt'])->name('filter.skpt');

    // ================================
    // KECAMATAN ROUTES
    // ================================
    Route::resource('kecamatan', KecamatanController::class)->except(['index', 'create', 'store', 'show', 'edit', 'update', 'destroy']);

    Route::middleware('permission:kecamatan.view')->group(function () {
        Route::get('kecamatan', [KecamatanController::class, 'index'])->name('kecamatan.index');
        Route::get('kecamatan/{kecamatan}', [KecamatanController::class, 'show'])->name('kecamatan.show');
    });

    Route::middleware('permission:kecamatan.create')->group(function () {
        Route::get('kecamatan/create', [KecamatanController::class, 'create'])->name('kecamatan.create');
        Route::post('kecamatan', [KecamatanController::class, 'store'])->name('kecamatan.store');
    });

    Route::middleware('permission:kecamatan.edit')->group(function () {
        Route::get('kecamatan/{kecamatan}/edit', [KecamatanController::class, 'edit'])->name('kecamatan.edit');
        Route::put('kecamatan/{kecamatan}', [KecamatanController::class, 'update'])->name('kecamatan.update');
    });

    Route::middleware('permission:kecamatan.delete')->group(function () {
        Route::delete('kecamatan/{kecamatan}', [KecamatanController::class, 'destroy'])->name('kecamatan.destroy');
    });

    // ================================
    // KAMPUNG ROUTES
    // ================================
    Route::middleware('permission:kampung.view')->group(function () {
        Route::get('kampung', [KampungController::class, 'index'])->name('kampung.index');
        Route::get('kampung/{kampung}', [KampungController::class, 'show'])->name('kampung.show');
    });

    Route::middleware('permission:kampung.create')->group(function () {
        Route::get('kampung/create', [KampungController::class, 'create'])->name('kampung.create');
        Route::post('kampung', [KampungController::class, 'store'])->name('kampung.store');
    });

    Route::middleware('permission:kampung.edit')->group(function () {
        Route::get('kampung/{kampung}/edit', [KampungController::class, 'edit'])->name('kampung.edit');
        Route::put('kampung/{kampung}', [KampungController::class, 'update'])->name('kampung.update');
    });

    Route::middleware('permission:kampung.delete')->group(function () {
        Route::delete('kampung/{kampung}', [KampungController::class, 'destroy'])->name('kampung.destroy');
    });

    // ================================
    // RTRW ROUTES
    // ================================
    Route::middleware('permission:rtrw.view')->group(function () {
        Route::get('rtrw', [RtrwController::class, 'index'])->name('rtrw.index');
        Route::get('rtrw/{rtrw}', [RtrwController::class, 'show'])->name('rtrw.show');
        Route::get('api/rtrw/all', [RtrwController::class, 'apiAll'])->name('rtrw.api.all');
    });

    Route::middleware('permission:rtrw.create')->group(function () {
        Route::get('rtrw/create', [RtrwController::class, 'create'])->name('rtrw.create');
        Route::post('rtrw', [RtrwController::class, 'store'])->name('rtrw.store');
    });

    Route::middleware('permission:rtrw.edit')->group(function () {
        Route::get('rtrw/{rtrw}/edit', [RtrwController::class, 'edit'])->name('rtrw.edit');
        Route::put('rtrw/{rtrw}', [RtrwController::class, 'update'])->name('rtrw.update');
    });

    Route::middleware('permission:rtrw.delete')->group(function () {
        Route::delete('rtrw/{rtrw}', [RtrwController::class, 'destroy'])->name('rtrw.destroy');
    });

    // ================================
    // ACTIVITY LOG ROUTES
    // ================================
    Route::prefix('activity-logs')->name('activity-logs.')->middleware('permission:activity-log.view')->group(function () {
        Route::get('/', [ActivityLogController::class, 'index'])->name('index');
        Route::get('/stats', [ActivityLogController::class, 'stats'])->name('stats');
        Route::get('/{activityLog}', [ActivityLogController::class, 'show'])->name('show');

        Route::get('/export', [ActivityLogController::class, 'export'])
            ->middleware('permission:activity-log.export')
            ->name('export');

        Route::delete('/clear', [ActivityLogController::class, 'clear'])
            ->middleware('permission:activity-log.clear')
            ->name('clear');
    });

    // ================================
    // SP-SIPT ROUTES
    // ================================
    Route::prefix('sp-sipt')->name('sp-sipt.')->group(function () {

        // View Permission Routes
        Route::middleware('permission:sp-sipt.view')->group(function () {
            Route::get('/', [SpSiptController::class, 'index'])->name('index');
            Route::get('/dashboard', [SpSiptController::class, 'dashboard'])->name('dashboard');
            Route::get('/statistics', [SpSiptController::class, 'getStatistics'])->name('statistics');
            Route::get('/map', [SpSiptController::class, 'map'])->name('map');
            Route::get('/report', [SpSiptController::class, 'report'])->name('report');
            Route::post('/report/generate', [SpSiptController::class, 'generateReport'])->name('report.generate');
            Route::get('/export/excel', [SpSiptController::class, 'exportExcel'])->name('export.excel');
            Route::get('/export/template', [SpSiptController::class, 'downloadTemplate'])->name('export.template');
            Route::get('/search', [SpSiptController::class, 'search'])->name('search');
            Route::get('/kelurahan', [SpSiptController::class, 'getKelurahan'])->name('kelurahan');
            Route::get('/kecamatan', [SpSiptController::class, 'getKecamatan'])->name('kecamatan');
            Route::get('/{sp_sipt}', [SpSiptController::class, 'show'])->name('show');
            Route::get('/{sp_sipt}/detail', [SpSiptController::class, 'getDetail'])->name('detail');
            Route::get('/{sp_sipt}/download/{documentType?}', [SpSiptController::class, 'downloadDocument'])->name('downloadDocument');
            Route::get('/{sp_sipt}/activity', [SpSiptController::class, 'activityLog'])->name('activity');
        });

        // Create Permission Routes
        Route::middleware('permission:sp-sipt.create')->group(function () {
            Route::get('/create', [SpSiptController::class, 'create'])->name('create');
            Route::post('/', [SpSiptController::class, 'store'])->name('store');
            Route::post('/import', [SpSiptController::class, 'import'])->name('import');
            Route::post('/{sp_sipt}/duplicate', [SpSiptController::class, 'duplicate'])->name('duplicate');
        });

        // Edit Permission Routes
        Route::middleware('permission:sp-sipt.edit')->group(function () {
            Route::get('/{sp_sipt}/edit', [SpSiptController::class, 'edit'])->name('edit');
            Route::put('/{sp_sipt}', [SpSiptController::class, 'update'])->name('update');
            Route::post('/{sp_sipt}/catatan', [SpSiptController::class, 'storeCatatan'])->name('catatan.store');
            Route::post('/{sp_sipt}/jadwal', [SpSiptController::class, 'storeJadwal'])->name('jadwal.store');
            Route::put('/{sp_sipt}/jadwal/{jadwal}', [SpSiptController::class, 'updateJadwal'])->name('jadwal.update');
        });

        // Delete Permission Routes
        Route::middleware('permission:sp-sipt.delete')->group(function () {
            Route::delete('/{sp_sipt}', [SpSiptController::class, 'destroy'])->name('destroy');
            Route::delete('/{sp_sipt}/dokumen/{dokumen}', [SpSiptController::class, 'destroyDokumen'])->name('dokumen.destroy');
            Route::delete('/dokumen/{id}', [SpSiptController::class, 'deleteDokumen'])->name('dokumen.delete');
        });

        // Update Status Permission Routes
        Route::middleware('permission:sp-sipt.update-status')->group(function () {
            Route::post('/{sp_sipt}/status', [SpSiptController::class, 'updateStatus'])->name('updateStatus');
            Route::post('/{sp_sipt}/update-status-ajax', [SpSiptController::class, 'updateStatusAjax'])->name('updateStatusAjax');
            Route::post('/{sp_sipt}/send-email', [SpSiptController::class, 'sendEmail'])->name('sendEmail');
        });

        // Print Permission Routes
        Route::middleware('permission:sp-sipt.print')->group(function () {
            Route::get('/{sp_sipt}/print', [SpSiptController::class, 'print'])->name('print');
            Route::get('/{sp_sipt}/pdf', [SpSiptController::class, 'exportPdf'])->name('pdf');
            Route::get('/{sp_sipt}/export-pdf', [SpSiptController::class, 'exportPdf'])->name('exportPdf');
        });

        // Preview Permission Routes
        Route::middleware('permission:sp-sipt.preview')->group(function () {
            Route::get('/{sp_sipt}/preview', [SpSiptController::class, 'preview'])->name('preview');
        });

        // Trash Management (Superadmin only)
        Route::prefix('trash')->name('trash.')->middleware('role:superadmin')->group(function () {
            Route::post('/{id}/restore', [SpSiptController::class, 'restore'])->name('restore');
            Route::delete('/{id}/force', [SpSiptController::class, 'forceDestroy'])->name('force');
        });
    });

    // ================================
    // SKPT ROUTES
    // ================================
    Route::prefix('skpt')->name('skpt.')->group(function () {

        // View Permission Routes
        Route::middleware('permission:skpt.view')->group(function () {
            Route::get('/', [SKPTController::class, 'index'])->name('index');
            Route::get('/{skpt}', [SKPTController::class, 'show'])->name('show');
            Route::get('/table-data', [SKPTController::class, 'getTableData'])->name('getTableData');
            Route::get('/total-count', [SKPTController::class, 'getTotalCount'])->name('getTotalCount');
            Route::get('/polygon-data', [SKPTController::class, 'getPolygonData'])->name('getPolygonData');
            Route::get('/detail-data', [SKPTController::class, 'getDetailData'])->name('getDetailData');
            Route::post('/filter', [SKPTController::class, 'filterSkpt'])->name('filter');
            Route::get('/{skpt}/documents/{document}/download', [SKPTController::class, 'downloadDocument'])->name('documents.download');
            Route::get('/{skpt}/additional-documents/{additional_document}/download', [SKPTController::class, 'downloadAdditionalDocument'])->name('additional-documents.download');
        });

        // Create Permission Routes
        Route::middleware('permission:skpt.create')->group(function () {
            Route::get('/create', [SKPTController::class, 'create'])->name('create');
            Route::post('/', [SKPTController::class, 'store'])->name('store');
        });

        // Edit Permission Routes
        Route::middleware('permission:skpt.edit')->group(function () {
            Route::get('/{skpt}/edit', [SKPTController::class, 'edit'])->name('edit');
            Route::put('/{skpt}', [SKPTController::class, 'update'])->name('update');
        });

        // Delete Permission Routes
        Route::middleware('permission:skpt.delete')->group(function () {
            Route::delete('/{skpt}', [SKPTController::class, 'destroy'])->name('destroy');
            Route::delete('/{skpt}/additional-documents/{additional_document}', [SKPTController::class, 'deleteAdditionalDocument'])->name('additional-documents.destroy');
        });

        // Upload Document Permission Routes
        Route::middleware('permission:skpt.upload-document')->group(function () {
            Route::post('/{skpt}/documents/{document}/upload', [SKPTController::class, 'uploadDocument'])->name('documents.upload');
            Route::post('/{skpt}/additional-documents/upload', [SKPTController::class, 'uploadAdditionalDocument'])->name('additional-documents.upload');
        });

        // Verify Document Permission Routes
        Route::middleware('permission:skpt.verify-document')->group(function () {
            Route::post('/{skpt}/documents/{document}/verify', [SKPTController::class, 'verifyDocument'])->name('documents.verify');
            Route::post('/{skpt}/additional-documents/{additional_document}/verify', [SKPTController::class, 'verifyAdditionalDocument'])->name('additional-documents.verify');
        });

        // Update Status Permission Routes
        Route::middleware('permission:skpt.update-status')->group(function () {
            Route::post('/{skpt}/update-status', [SKPTController::class, 'updateStatus'])->name('updateStatus');
        });

        // Preview Permission Routes
        Route::middleware('permission:skpt.preview')->group(function () {
            Route::get('/{skpt}/preview', [SKPTController::class, 'preview'])->name('preview');
        });

        // Print Permission Routes
        Route::middleware('permission:skpt.print')->group(function () {
            Route::get('/{skpt}/print', [SKPTController::class, 'print'])->name('print');
        });
    });

    // ================================
    // PENINJAUAN ROUTES
    // ================================
    Route::prefix('peninjauan')->name('peninjauan.')->group(function () {

        // View Permission Routes
        Route::middleware('permission:peninjauan.view')->group(function () {
            Route::get('/', [PeninjauanController::class, 'index'])->name('index');
            Route::get('/{peninjauan}', [PeninjauanController::class, 'show'])->name('show');
        });

        // Create Permission Routes
        Route::middleware('permission:peninjauan.create')->group(function () {
            Route::get('/create', [PeninjauanController::class, 'create'])->name('create');
            Route::post('/', [PeninjauanController::class, 'store'])->name('store');
        });

        // Edit Permission Routes
        Route::middleware('permission:peninjauan.edit')->group(function () {
            Route::get('/{peninjauan}/edit', [PeninjauanController::class, 'edit'])->name('edit');
            Route::put('/{peninjauan}', [PeninjauanController::class, 'update'])->name('update');
        });

        // Delete Permission Routes
        Route::middleware('permission:peninjauan.delete')->group(function () {
            Route::delete('/{peninjauan}', [PeninjauanController::class, 'destroy'])->name('destroy');
            Route::get('/{peninjauan}/restore', [PeninjauanController::class, 'restore'])->name('restore');
        });

        // Update Status Permission Routes
        Route::middleware('permission:peninjauan.update-status')->group(function () {
            Route::post('/update-status/{id}', [PeninjauanController::class, 'updateStatus'])->name('updateStatus');
        });

        // Preview Permission Routes
        Route::middleware('permission:peninjauan.preview')->group(function () {
            Route::get('/{peninjauan}/preview', [PeninjauanController::class, 'preview'])->name('preview');
        });

        // Print Permission Routes
        Route::middleware('permission:peninjauan.print')->group(function () {
            Route::get('/{peninjauan}/export-pdf', [PeninjauanController::class, 'exportPdf'])->name('exportPdf');
        });
    });

    // ================================
    // PENERBITAN SKPT ROUTES
    // ================================
    Route::prefix('penerbitan-skpt')->name('penerbitan-skpt.')->group(function () {

        // View Permission Routes
        Route::middleware('permission:penerbitan-skpt.view')->group(function () {
            Route::get('/', [PenerbitanSKPTController::class, 'index'])->name('index');
            Route::get('/{id}', [PenerbitanSKPTController::class, 'show'])->name('show');
            Route::get('/{id}/preview', [PenerbitanSKPTController::class, 'preview'])->name('preview');
            Route::get('/{id}/verification-history', [PenerbitanSKPTController::class, 'getVerificationHistory'])->name('verification-history');
        });

        // Verify Permission Routes
        Route::middleware('permission:penerbitan-skpt.verify')->group(function () {
            Route::post('/{id}/verify', [PenerbitanSKPTController::class, 'verifyDocument'])->name('verify');
            Route::patch('/{id}/status', [PenerbitanSKPTController::class, 'updateDocumentStatus'])->name('update-status');
        });

        // Finalize Permission Routes
        Route::middleware('permission:penerbitan-skpt.finalize')->group(function () {
            Route::post('/{id}/finalize', [PenerbitanSKPTController::class, 'finalizeDocument'])->name('finalize');
        });

        // Print Permission Routes
        Route::middleware('permission:penerbitan-skpt.print')->group(function () {
            Route::get('/{id}/print', [PenerbitanSKPTController::class, 'printSkpt'])->name('print');
        });
    });

    // ================================
    // PENERBITAN SPMPT ROUTES
    // ================================
    Route::prefix('penerbitan-spmpt')->name('penerbitan-spmpt.')->group(function () {

        // View Permission Routes
        Route::middleware('permission:penerbitan-spmpt.view')->group(function () {
            Route::get('/', [PenerbitanSpmptController::class, 'index'])->name('index');
            Route::get('/{id}', [PenerbitanSpmptController::class, 'show'])->name('show');
            Route::get('/{id}/preview', [PenerbitanSpmptController::class, 'preview'])->name('preview');
            Route::get('/{id}/verification-history', [PenerbitanSpmptController::class, 'getVerificationHistory'])->name('verification-history');
        });

        // Verify Permission Routes
        Route::middleware('permission:penerbitan-spmpt.verify')->group(function () {
            Route::post('/{id}/verify', [PenerbitanSpmptController::class, 'verifyDocument'])->name('verify');
            Route::patch('/{id}/status', [PenerbitanSpmptController::class, 'updateDocumentStatus'])->name('update-status');
        });

        // Finalize Permission Routes
        Route::middleware('permission:penerbitan-spmpt.finalize')->group(function () {
            Route::post('/{id}/finalize', [PenerbitanSpmptController::class, 'finalizeDocument'])->name('finalize');
        });

        // Print Permission Routes
        Route::middleware('permission:penerbitan-spmpt.print')->group(function () {
            Route::get('/{id}/print', [PenerbitanSpmptController::class, 'printSkpt'])->name('print');
        });
    });

    // ================================
    // USER MANAGEMENT ROUTES
    // ================================
    Route::prefix('users')->name('users.')->group(function () {

        // View Permission Routes
        Route::middleware('permission:user.view')->group(function () {
            Route::get('/', [UserController::class, 'index'])->name('index');
            Route::get('/{user}', [UserController::class, 'show'])->name('show');
        });

        // Create Permission Routes
        Route::middleware('permission:user.create')->group(function () {
            Route::get('/create', [UserController::class, 'create'])->name('create');
            Route::post('/', [UserController::class, 'store'])->name('store');
        });

        // Edit Permission Routes
        Route::middleware('permission:user.edit')->group(function () {
            Route::get('/{user}/edit', [UserController::class, 'edit'])->name('edit');
            Route::put('/{user}', [UserController::class, 'update'])->name('update');
        });

        // Delete Permission Routes
        Route::middleware('permission:user.delete')->group(function () {
            Route::delete('/{user}', [UserController::class, 'destroy'])->name('destroy');
        });
    });

    // ================================
    // USER PROFILE ROUTES (All authenticated users)
    // ================================
    Route::get('/profile/{user}', [UserController::class, 'showEditProfile'])->name('user.profile');
    Route::put('/profile/{user}', [UserController::class, 'editProfile'])->name('user.profile.update');

    // ================================
    // ROLE & PERMISSION MANAGEMENT ROUTES
    // ================================
    Route::prefix('roles')->name('roles.')->middleware('permission:role.view')->group(function () {

        // View Permission Routes
        Route::get('/', [RoleController::class, 'index'])->name('index');
        Route::get('/{role}', [RoleController::class, 'show'])->name('show');
        Route::get('/{role}/permissions', [RoleController::class, 'permissions'])->name('permissions');

        // Create Permission Routes
        Route::middleware('permission:role.create')->group(function () {
            Route::get('/create', [RoleController::class, 'create'])->name('create');
            Route::post('/', [RoleController::class, 'store'])->name('store');
        });

        // Edit Permission Routes
        Route::middleware('permission:role.edit')->group(function () {
            Route::get('/{role}/edit', [RoleController::class, 'edit'])->name('edit');
            Route::put('/{role}', [RoleController::class, 'update'])->name('update');
        });

        // Delete Permission Routes
        Route::middleware('permission:role.delete')->group(function () {
            Route::delete('/{role}', [RoleController::class, 'destroy'])->name('destroy');
        });

        // Assign Permissions Routes
        Route::middleware('permission:role.assign-permissions')->group(function () {
            Route::post('/{role}/permissions', [RoleController::class, 'updatePermissions'])->name('update-permissions');
            Route::put('/{role}/permissions', [RoleController::class, 'syncPermissions'])->name('sync-permissions');
        });
    });
});
